/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.handly.util.IndentationPolicy;

public final class ToStringStyle {
    public static final IndentationPolicy DEFAULT_INDENTATION_POLICY = new IndentationPolicy();
    public static final ToStringStyle MINIMAL = new ToStringStyle(EnumSet.noneOf(Option.class));
    public static final ToStringStyle COMPACT = new ToStringStyle(EnumSet.of(Option.ANCESTORS));
    public static final ToStringStyle FULL = new ToStringStyle(EnumSet.allOf(Option.class));
    private final Set<Option> options;
    private final IndentationPolicy indentationPolicy;
    private final int indentationLevel;

    public ToStringStyle(EnumSet<Option> options) {
        this(options, DEFAULT_INDENTATION_POLICY, 0);
    }

    public ToStringStyle(EnumSet<Option> options, IndentationPolicy indentationPolicy, int indentationLevel) {
        if (options == null) {
            throw new IllegalArgumentException();
        }
        if (indentationPolicy == null) {
            throw new IllegalArgumentException();
        }
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        this.options = Collections.unmodifiableSet(options);
        this.indentationPolicy = indentationPolicy;
        this.indentationLevel = indentationLevel;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public IndentationPolicy getIndentationPolicy() {
        return this.indentationPolicy;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public static enum Option {
        ANCESTORS,
        CHILDREN;

    }
}

