/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;

public class DefaultWorkingCopyInfo
extends WorkingCopyInfo {
    private final Object reconcilingLock = new Object();
    private volatile ISnapshot reconciledSnapshot;

    public DefaultWorkingCopyInfo(IBuffer buffer) {
        super(buffer);
    }

    @Override
    protected boolean needsReconciling() {
        return !this.getBuffer().getSnapshot().isEqualTo(this.reconciledSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void reconcile(boolean force, Object arg, IProgressMonitor monitor) throws CoreException {
        Object object = this.reconcilingLock;
        synchronized (object) {
            boolean needsReconciling = this.needsReconciling();
            if (needsReconciling || force) {
                NonExpiringSnapshot snapshot = new NonExpiringSnapshot(this.getBuffer());
                this.reconcile(snapshot, !needsReconciling, arg, monitor);
                this.reconciledSnapshot = snapshot.getWrappedSnapshot();
            }
        }
    }

    protected void reconcile(NonExpiringSnapshot snapshot, boolean forced, Object arg, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 2);
        try {
            Object ast = this.workingCopy.hCreateStructuralAst(snapshot.getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.workingCopy.hReconcileOperation().reconcile(ast, snapshot, forced, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }
}

