/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ToStringStyle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.handly.model.impl.IElementImpl;
import org.eclipse.handly.util.IndentationPolicy;

public abstract class Element
extends PlatformObject
implements IElementImpl {
    protected static final Object NO_BODY = new Object();
    private final Element parent;
    private final String name;

    public Element(Element parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Element)) {
            return false;
        }
        Element other = (Element)obj;
        if (!this.hElementType().equals(other.hElementType())) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.hToString(ToStringStyle.DEFAULT_INDENTATION_POLICY, 0, builder);
        return builder.toString();
    }

    @Override
    public final String hName() {
        return this.name;
    }

    @Override
    public final Element hParent() {
        return this.parent;
    }

    @Override
    public boolean hExists() {
        if (this.hFindBody() != null) {
            return true;
        }
        if (this.parent != null && !this.parent.hExists()) {
            return false;
        }
        try {
            this.hValidateExistence();
            return true;
        }
        catch (CoreException e) {
            return false;
        }
    }

    @Override
    public IElement[] hChildren() throws CoreException {
        return this.hChildren(this.hBody());
    }

    public Object hFindBody() {
        return this.hElementManager().get(this);
    }

    public Object hPeekAtBody() {
        return this.hElementManager().peek(this);
    }

    public final boolean hClose() {
        return this.hClose(true);
    }

    @Override
    public String hToString(ToStringStyle style) {
        StringBuilder builder = new StringBuilder();
        if (style.getOptions().contains((Object)ToStringStyle.Option.CHILDREN)) {
            this.hToString(style.getIndentationPolicy(), style.getIndentationLevel(), builder);
        } else {
            this.hToStringBody(style.getIndentationPolicy(), style.getIndentationLevel(), builder, NO_BODY, true);
            if (style.getOptions().contains((Object)ToStringStyle.Option.ANCESTORS)) {
                this.hToStringAncestors(builder);
            }
        }
        return builder.toString();
    }

    public String hToDebugString() {
        StringBuilder builder = new StringBuilder();
        this.hToStringBody(ToStringStyle.DEFAULT_INDENTATION_POLICY, 0, builder, NO_BODY, true);
        return builder.toString();
    }

    public String hToStringWithAncestors() {
        return this.hToStringWithAncestors(true);
    }

    public String hToStringWithAncestors(boolean showResolvedInfo) {
        StringBuilder builder = new StringBuilder();
        this.hToStringBody(ToStringStyle.DEFAULT_INDENTATION_POLICY, 0, builder, NO_BODY, showResolvedInfo);
        this.hToStringAncestors(builder);
        return builder.toString();
    }

    public Object hToStringBody(IndentationPolicy indentationPolicy, int indentationLevel, StringBuilder builder) {
        Object body = this.hPeekAtBody();
        this.hToStringBody(indentationPolicy, indentationLevel, builder, body, true);
        return body;
    }

    protected void hToStringAncestors(StringBuilder builder) {
        if (this.parent != null && this.parent.hParent() != null) {
            builder.append(" [in ");
            this.parent.hToStringBody(ToStringStyle.DEFAULT_INDENTATION_POLICY, 0, builder, NO_BODY, false);
            this.parent.hToStringAncestors(builder);
            builder.append(']');
        }
    }

    protected void hToString(IndentationPolicy indentationPolicy, int indentationLevel, StringBuilder builder) {
        Object body = this.hToStringBody(indentationPolicy, indentationLevel, builder);
        if (indentationLevel == 0) {
            this.hToStringAncestors(builder);
        }
        this.hToStringChildren(indentationPolicy, indentationLevel, builder, body);
    }

    protected void hToStringChildren(IndentationPolicy indentationPolicy, int indentationLevel, StringBuilder builder, Object body) {
        if (body == null) {
            return;
        }
        ToStringStyle childStyle = null;
        IElement[] iElementArray = this.hChildren(body);
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            indentationPolicy.appendLineSeparatorTo(builder);
            if (childStyle == null) {
                childStyle = new ToStringStyle(EnumSet.of(ToStringStyle.Option.CHILDREN), indentationPolicy, indentationLevel + 1);
            }
            builder.append(Elements.toString(child, childStyle));
            ++n2;
        }
    }

    protected void hToStringBody(IndentationPolicy indentationPolicy, int indentationLevel, StringBuilder builder, Object body, boolean showResolvedInfo) {
        indentationPolicy.appendIndentTo(builder, indentationLevel);
        this.hToStringName(builder);
        if (body == null) {
            builder.append(" (not open)");
        }
    }

    protected void hToStringName(StringBuilder builder) {
        builder.append(this.name);
    }

    protected Object hElementType() {
        return this.getClass();
    }

    protected abstract ElementManager hElementManager();

    protected abstract void hValidateExistence() throws CoreException;

    protected abstract void hBuildStructure(Object var1, Map<IElement, Object> var2, IProgressMonitor var3) throws CoreException;

    protected final Object hBody() throws CoreException {
        return this.hBody(null);
    }

    protected final Object hBody(IProgressMonitor monitor) throws CoreException {
        Object body = this.hFindBody();
        if (body != null) {
            return body;
        }
        return this.hOpen(this.hNewBody(), false, monitor);
    }

    protected Object hNewBody() {
        if (!this.hIsOpenable()) {
            return null;
        }
        return new Body();
    }

    protected IElement[] hChildren(Object body) {
        return ((Body)body).getChildren();
    }

    final Object hOpen(Object body, boolean force, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ElementManager elementManager = this.hElementManager();
        boolean hadTemporaryCache = elementManager.hasTemporaryCache();
        try {
            Map<IElement, Object> newElements = elementManager.getTemporaryCache();
            this.hGenerateBodies(body, newElements, monitor);
            if (body == null) {
                body = newElements.get(this);
            }
            if (body == null) {
                throw new CoreException(Activator.createErrorStatus("The element does not exist: " + this.toString(), null));
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!hadTemporaryCache) {
                if (force) {
                    elementManager.put(this, newElements);
                } else {
                    Object existingBody = elementManager.putIfAbsent(this, newElements);
                    if (existingBody != null) {
                        body = existingBody;
                    }
                }
            }
        }
        finally {
            if (!hadTemporaryCache) {
                elementManager.resetTemporaryCache();
            }
        }
        return body;
    }

    protected boolean hIsOpenable() {
        return true;
    }

    protected final Element hOpenableParent() {
        Element result = this.parent;
        while (result != null && !result.hIsOpenable()) {
            result = result.parent;
        }
        return result;
    }

    protected void hGenerateAncestorBodies(Map<IElement, Object> newElements, IProgressMonitor monitor) throws CoreException {
        Element openableParent = this.hOpenableParent();
        if (openableParent != null && openableParent.hFindBody() == null) {
            openableParent.hGenerateBodies(openableParent.hNewBody(), newElements, monitor);
        }
    }

    protected final void hGenerateBodies(Object body, Map<IElement, Object> newElements, IProgressMonitor monitor) throws CoreException {
        block8: {
            monitor.beginTask("", 2);
            try {
                if (this.hIsOpenable() ? body == null : body != null) {
                    throw new IllegalArgumentException();
                }
                this.hGenerateAncestorBodies(newElements, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (body == null) break block8;
                this.hValidateExistence();
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                newElements.put(this, body);
                try {
                    this.hBuildStructure(body, newElements, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    newElements.remove(this);
                    throw e;
                }
                catch (RuntimeException e) {
                    newElements.remove(this);
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected boolean hClose(boolean external) {
        if (external && !this.hIsOpenable()) {
            return false;
        }
        this.hElementManager().remove(this);
        return true;
    }

    protected void hRemoving(Object body) {
    }
}

