/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ToStringStyle;

public interface IElementImpl
extends IElement {
    public String hName();

    public IElement hParent();

    default public IElement hRoot() {
        IElement parent = this.hParent();
        if (parent == null) {
            return this;
        }
        return Elements.getRoot(parent);
    }

    default public <T> T hAncestor(Class<T> ancestorType) {
        IElement parent = this.hParent();
        if (parent == null) {
            return null;
        }
        if (ancestorType.isInstance(parent)) {
            return ancestorType.cast(parent);
        }
        return Elements.getAncestor(parent, ancestorType);
    }

    public IResource hResource();

    default public IPath hPath() {
        IResource resource = this.hResource();
        if (resource != null) {
            return resource.getFullPath();
        }
        throw new AssertionError((Object)"Please override the default implementation of this method");
    }

    public boolean hExists();

    public IElement[] hChildren() throws CoreException;

    default public <T> T[] hChildren(Class<T> childType) throws CoreException {
        IElement[] children = this.hChildren();
        ArrayList<T> list = new ArrayList<T>(children.length);
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            if (childType.isInstance(child)) {
                list.add(childType.cast(child));
            }
            ++n2;
        }
        Object[] result = (Object[])Array.newInstance(childType, list.size());
        return list.toArray(result);
    }

    public String hToString(ToStringStyle var1);
}

