/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.handly.model.impl.IWorkingCopyInfoFactory;
import org.eclipse.handly.model.impl.Messages;
import org.eclipse.handly.model.impl.SourceElement;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.handly.util.TextRange;

public abstract class SourceFile
extends SourceElement
implements ISourceFileImpl {
    private static final ThreadLocal<AstHolder> AST_HOLDER = new ThreadLocal();
    private final IFile file;

    public SourceFile(Element parent, IFile file) {
        super(parent, file.getName());
        this.file = file;
    }

    @Override
    public final IResource hResource() {
        return this.file;
    }

    @Override
    public final IFile hFile() {
        return this.file;
    }

    @Override
    public final IBuffer hBuffer(boolean create, IProgressMonitor monitor) throws CoreException {
        WorkingCopyInfo info = this.hAcquireWorkingCopy();
        if (info == null) {
            if (!create && ITextFileBufferManager.DEFAULT.getTextFileBuffer(this.file.getFullPath(), LocationKind.IFILE) == null) {
                return null;
            }
            return new TextFileBuffer(this.file, ITextFileBufferManager.DEFAULT);
        }
        try {
            IBuffer buffer = info.getBuffer();
            buffer.addRef();
            IBuffer iBuffer = buffer;
            return iBuffer;
        }
        finally {
            this.hDiscardWorkingCopy();
        }
    }

    public final WorkingCopyInfo hBecomeWorkingCopy(IBuffer buffer, IProgressMonitor monitor) throws CoreException {
        return this.hBecomeWorkingCopy(buffer, null, monitor);
    }

    public final WorkingCopyInfo hBecomeWorkingCopy(final IBuffer buffer, final IWorkingCopyInfoFactory factory, final IProgressMonitor monitor) throws CoreException {
        WorkingCopyProvider provider = new WorkingCopyProvider(this){

            @Override
            protected WorkingCopyInfo doAcquireWorkingCopy() {
                return this.putWorkingCopyInfoIfAbsent(buffer, factory);
            }

            @Override
            protected boolean isCanceled() {
                if (monitor == null) {
                    return false;
                }
                return monitor.isCanceled();
            }
        };
        WorkingCopyInfo oldInfo = provider.acquireWorkingCopy();
        if (oldInfo == null) {
            boolean success = false;
            try {
                WorkingCopyInfo newInfo = this.hPeekAtWorkingCopyInfo();
                newInfo.workingCopy = this;
                newInfo.initTask.execute(monitor);
                success = true;
            }
            finally {
                if (!success) {
                    this.hDiscardWorkingCopy();
                }
            }
        }
        return oldInfo;
    }

    public final WorkingCopyInfo hAcquireWorkingCopy() {
        WorkingCopyProvider provider = new WorkingCopyProvider(this){

            @Override
            protected WorkingCopyInfo doAcquireWorkingCopy() {
                return this.getWorkingCopyInfo();
            }
        };
        return provider.acquireWorkingCopy();
    }

    public final boolean hDiscardWorkingCopy() {
        WorkingCopyInfo info = this.hElementManager().discardWorkingCopyInfo(this);
        if (info == null) {
            throw new IllegalStateException("Not a working copy: " + this.hPath());
        }
        if (info.isDisposed() && info.created) {
            this.hWorkingCopyModeChanged();
            return true;
        }
        return false;
    }

    @Override
    public final boolean hIsWorkingCopy() {
        WorkingCopyInfo info = this.hPeekAtWorkingCopyInfo();
        if (info == null) {
            return false;
        }
        if (info.created) {
            return true;
        }
        AstHolder astHolder = AST_HOLDER.get();
        return astHolder != null && astHolder.getSourceFile().equals(this);
    }

    @Override
    public final boolean hNeedsReconciling() {
        WorkingCopyInfo info = this.hAcquireWorkingCopy();
        if (info == null) {
            return false;
        }
        try {
            boolean bl = info.needsReconciling();
            return bl;
        }
        finally {
            this.hDiscardWorkingCopy();
        }
    }

    @Override
    public final void hReconcile(boolean force, Object arg, IProgressMonitor monitor) throws CoreException {
        WorkingCopyInfo info = this.hAcquireWorkingCopy();
        if (info == null) {
            return;
        }
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            info.reconcile(force, arg, monitor);
        }
        finally {
            this.hDiscardWorkingCopy();
        }
    }

    public ReconcileOperation hReconcileOperation() {
        return new ReconcileOperation();
    }

    protected final WorkingCopyInfo hPeekAtWorkingCopyInfo() {
        return this.hElementManager().peekAtWorkingCopyInfo(this);
    }

    protected void hWorkingCopyModeChanged() {
    }

    @Override
    protected SourceElementBody hNewBody() {
        return new SourceElementBody();
    }

    @Override
    protected void hValidateExistence() throws CoreException {
        if (!this.hIsWorkingCopy() && !this.file.exists()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.SourceFile_File_does_not_exist__0, this.file.getFullPath().makeRelative()), null));
        }
    }

    @Override
    protected final void hBuildStructure(Object body, Map<IElement, Object> newElements, IProgressMonitor monitor) throws CoreException {
        int ticks = 2;
        monitor.beginTask("", ticks);
        try {
            AstHolder astHolder = AST_HOLDER.get();
            if (astHolder == null) {
                NonExpiringSnapshot snapshot;
                try {
                    snapshot = new NonExpiringSnapshot(new ISnapshotProvider(){

                        @Override
                        public ISnapshot getSnapshot() {
                            TextFileSnapshot result = new TextFileSnapshot(SourceFile.this.file, true);
                            if (result.getContents() == null && !result.getStatus().isOK()) {
                                throw new IllegalStateException(new CoreException(result.getStatus()));
                            }
                            return result;
                        }
                    });
                }
                catch (IllegalStateException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CoreException) {
                        throw (CoreException)cause;
                    }
                    throw new AssertionError((Object)e);
                }
                Object ast = this.hCreateStructuralAst(snapshot.getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                astHolder = new AstHolder(ast, snapshot);
                --ticks;
            }
            if (!astHolder.getSourceFile().equals(this)) {
                throw new AssertionError();
            }
            SourceElementBody thisBody = (SourceElementBody)body;
            String source = astHolder.snapshot.getContents();
            ISnapshot snapshot = astHolder.snapshot.getWrappedSnapshot();
            this.hBuildStructure(thisBody, newElements, astHolder.ast, source, (IProgressMonitor)new SubProgressMonitor(monitor, ticks));
            thisBody.setFullRange(new TextRange(0, source.length()));
            SourceFile.setSnapshot(thisBody, snapshot, newElements);
        }
        finally {
            monitor.done();
        }
    }

    protected abstract Object hCreateStructuralAst(String var1, IProgressMonitor var2) throws CoreException;

    protected abstract void hBuildStructure(SourceElementBody var1, Map<IElement, Object> var2, Object var3, String var4, IProgressMonitor var5);

    @Override
    protected void hToStringName(StringBuilder builder) {
        if (this.hIsWorkingCopy()) {
            builder.append("[Working copy] ");
        }
        super.hToStringName(builder);
    }

    @Override
    protected void hGenerateAncestorBodies(Map<IElement, Object> newElements, IProgressMonitor monitor) throws CoreException {
        if (this.hIsWorkingCopy()) {
            return;
        }
        super.hGenerateAncestorBodies(newElements, monitor);
    }

    @Override
    protected boolean hClose(boolean external) {
        if (this.hIsWorkingCopy()) {
            return false;
        }
        return super.hClose(external);
    }

    private static void setSnapshot(SourceElementBody body, ISnapshot snapshot, Map<IElement, Object> newElements) {
        body.setSnapshot(snapshot);
        ISourceConstruct[] iSourceConstructArray = body.getChildren();
        int n = iSourceConstructArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceConstruct child = iSourceConstructArray[n2];
            SourceFile.setSnapshot((SourceElementBody)newElements.get(child), snapshot, newElements);
            ++n2;
        }
    }

    private WorkingCopyInfo putWorkingCopyInfoIfAbsent(IBuffer buffer, IWorkingCopyInfoFactory factory) {
        return this.hElementManager().putWorkingCopyInfoIfAbsent(this, buffer, factory);
    }

    private WorkingCopyInfo getWorkingCopyInfo() {
        return this.hElementManager().getWorkingCopyInfo(this);
    }

    private class AstHolder {
        public final Object ast;
        public final NonExpiringSnapshot snapshot;

        public AstHolder(Object ast, NonExpiringSnapshot snapshot) {
            this.ast = ast;
            this.snapshot = snapshot;
        }

        public SourceFile getSourceFile() {
            return SourceFile.this;
        }
    }

    public class ReconcileOperation {
        public void reconcile(Object ast, NonExpiringSnapshot snapshot, boolean forced, IProgressMonitor monitor) throws CoreException {
            boolean create;
            WorkingCopyInfo info = SourceFile.this.hPeekAtWorkingCopyInfo();
            boolean bl = create = !info.created;
            if (create || !forced || this.shouldRebuildStructureIfForced()) {
                if (AST_HOLDER.get() != null) {
                    throw new AssertionError();
                }
                AST_HOLDER.set(new AstHolder(ast, snapshot));
                try {
                    SourceFile.this.hOpen(SourceFile.this.hNewBody(), true, monitor);
                }
                finally {
                    AST_HOLDER.set(null);
                }
            }
            if (create) {
                if (!info.created) {
                    throw new AssertionError();
                }
                SourceFile.this.hWorkingCopyModeChanged();
            }
        }

        protected boolean shouldRebuildStructureIfForced() {
            return false;
        }
    }

    private abstract class WorkingCopyProvider {
        private WorkingCopyProvider() {
        }

        public WorkingCopyInfo acquireWorkingCopy() {
            WorkingCopyInfo info;
            boolean success;
            do {
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                info = this.doAcquireWorkingCopy();
                if (info == null) {
                    return null;
                }
                success = false;
                try {
                    success = this.waitForInit(info);
                }
                finally {
                    if (!success) {
                        SourceFile.this.hDiscardWorkingCopy();
                    }
                }
            } while (!success);
            return info;
        }

        protected abstract WorkingCopyInfo doAcquireWorkingCopy();

        protected boolean isCanceled() {
            return false;
        }

        private boolean waitForInit(WorkingCopyInfo info) {
            int i = 0;
            while (i < 10) {
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    return info.initTask.wasSuccessful(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                ++i;
            }
            return false;
        }
    }
}

