/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.model.impl.SourceFile;

public abstract class WorkingCopyInfo {
    private final IBuffer buffer;
    final InitTask initTask = new InitTask();
    SourceFile workingCopy;
    volatile boolean created;
    int refCount;

    public WorkingCopyInfo(IBuffer buffer) {
        this.buffer = buffer;
        if (this.buffer == null) {
            throw new IllegalArgumentException();
        }
    }

    public final IBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        WorkingCopyInfo workingCopyInfo = this;
        synchronized (workingCopyInfo) {
            if (this.refCount > 0) {
                throw new IllegalStateException();
            }
            if (this.refCount < 0) {
                return;
            }
            this.refCount = -1;
        }
        this.onDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDisposed() {
        WorkingCopyInfo workingCopyInfo = this;
        synchronized (workingCopyInfo) {
            return this.refCount < 0;
        }
    }

    protected void onInit() throws CoreException {
    }

    protected void onDispose() {
    }

    protected abstract boolean needsReconciling();

    protected abstract void reconcile(boolean var1, Object var2, IProgressMonitor var3) throws CoreException;

    protected SourceFile getWorkingCopy() {
        return this.workingCopy;
    }

    public final boolean isInitialized() {
        try {
            return this.initTask.wasSuccessful(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    class InitTask {
        private IProgressMonitor monitor;
        private final FutureTask<?> futureTask = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws CoreException {
                InitTask.this.run();
                return null;
            }
        });

        InitTask() {
        }

        void execute(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.monitor = monitor;
            this.futureTask.run();
            this.monitor = null;
            try {
                this.futureTask.get();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CoreException) {
                    throw (CoreException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new AssertionError((Object)cause);
            }
        }

        boolean wasSuccessful(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            try {
                this.futureTask.get(timeout, unit);
                return true;
            }
            catch (ExecutionException e) {
                return false;
            }
        }

        private void run() throws CoreException {
            WorkingCopyInfo.this.onInit();
            WorkingCopyInfo.this.reconcile(true, null, this.monitor);
            if (!WorkingCopyInfo.this.created) {
                throw new AssertionError((Object)"Working copy creation was not completed. Ill-behaved implementation of #reconcile?");
            }
        }
    }
}

