/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.adapter;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.examples.adapter.JavaElement;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.IElementDeltaImpl;
import org.eclipse.jdt.core.IJavaElementDelta;

class JavaElementDelta
implements IElementDeltaImpl {
    private static final IMarkerDelta[] EMPTY_MARKER_DELTAS = new IMarkerDelta[0];
    private final IJavaElementDelta delta;
    private final int kind;
    private final long flags;

    public JavaElementDelta(IJavaElementDelta delta) {
        if (delta == null) {
            throw new IllegalArgumentException();
        }
        this.delta = delta;
        this.kind = JavaElementDelta.convertKind(delta);
        this.flags = JavaElementDelta.convertFlags(delta);
    }

    public IElement hElement() {
        return JavaElement.create(this.delta.getElement());
    }

    public int hKind() {
        return this.kind;
    }

    public long hFlags() {
        return this.flags;
    }

    public IElementDelta[] hAffectedChildren() {
        return JavaElementDelta.toElementDeltas(this.delta.getAffectedChildren());
    }

    public IElementDelta[] hAddedChildren() {
        return JavaElementDelta.toElementDeltas(this.delta.getAddedChildren());
    }

    public IElementDelta[] hRemovedChildren() {
        return JavaElementDelta.toElementDeltas(this.delta.getRemovedChildren());
    }

    public IElementDelta[] hChangedChildren() {
        return JavaElementDelta.toElementDeltas(this.delta.getChangedChildren());
    }

    public IElement hMovedFromElement() {
        return JavaElement.create(this.delta.getMovedFromElement());
    }

    public IElement hMovedToElement() {
        return JavaElement.create(this.delta.getMovedToElement());
    }

    public IMarkerDelta[] hMarkerDeltas() {
        return EMPTY_MARKER_DELTAS;
    }

    public IResourceDelta[] hResourceDeltas() {
        return this.delta.getResourceDeltas();
    }

    public String toString() {
        return this.delta.toString();
    }

    public String hToString(IContext context) {
        return this.toString();
    }

    private static int convertKind(IJavaElementDelta delta) {
        int kind = delta.getKind();
        switch (kind) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        throw new AssertionError();
    }

    private static long convertFlags(IJavaElementDelta delta) {
        int flags = delta.getFlags();
        long result = 0L;
        if ((flags & 8) != 0) {
            result |= 2L;
        }
        if ((flags & 1) != 0) {
            result |= 1L;
        }
        if ((flags & 0x4000) != 0) {
            result |= 0x20L;
        }
        if ((flags & 0x10) != 0) {
            result |= 4L;
        }
        if ((flags & 0x20) != 0) {
            result |= 8L;
        }
        if ((flags & 0x600) != 0) {
            result |= 0x40L;
        }
        if ((flags & 0x100) != 0) {
            result |= 0x10L;
        }
        if ((flags & 0x40000) != 0) {
            result |= 0x200L;
        }
        if ((flags & 0x10000) != 0) {
            result |= 0x100L;
        }
        return result;
    }

    private static IElementDelta[] toElementDeltas(IJavaElementDelta[] array) {
        int length = array.length;
        IElementDelta[] result = new IElementDelta[length];
        int i = 0;
        while (i < length) {
            result[i] = new JavaElementDelta(array[i]);
            ++i;
        }
        return result;
    }
}

