/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.HashMap;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.ElementCache;
import org.eclipse.handly.model.impl.IBodyCache;

class FooModelCache
implements IBodyCache {
    private static final int DEFAULT_PROJECT_SIZE = 5;
    private static final int DEFAULT_FILE_SIZE = 100;
    private static final int DEFAULT_CHILDREN_SIZE = 2000;
    private final double memoryRatio = this.getMemoryRatio();
    private Object modelBody;
    private HashMap<IElement, Object> projectCache = new HashMap(5);
    private ElementCache fileCache = new ElementCache((int)(100.0 * this.memoryRatio));
    private HashMap<IElement, Object> childrenCache = new HashMap((int)(2000.0 * this.memoryRatio));

    public Object get(IElement element) {
        if (element instanceof IFooModel) {
            return this.modelBody;
        }
        if (element instanceof IFooProject) {
            return this.projectCache.get(element);
        }
        if (element instanceof IFooFile) {
            return this.fileCache.get((Object)element);
        }
        return this.childrenCache.get(element);
    }

    public Object peek(IElement element) {
        if (element instanceof IFooModel) {
            return this.modelBody;
        }
        if (element instanceof IFooProject) {
            return this.projectCache.get(element);
        }
        if (element instanceof IFooFile) {
            return this.fileCache.peek((Object)element);
        }
        return this.childrenCache.get(element);
    }

    public void put(IElement element, Object body) {
        if (element instanceof IFooModel) {
            this.modelBody = body;
        } else if (element instanceof IFooProject) {
            this.projectCache.put(element, body);
            this.fileCache.ensureSpaceLimit(body, element);
        } else if (element instanceof IFooFile) {
            this.fileCache.put((Object)element, body);
        } else {
            this.childrenCache.put(element, body);
        }
    }

    public void remove(IElement element) {
        if (element instanceof IFooModel) {
            this.modelBody = null;
        } else if (element instanceof IFooProject) {
            this.projectCache.remove(element);
            this.fileCache.resetSpaceLimit((int)(100.0 * this.memoryRatio), element);
        } else if (element instanceof IFooFile) {
            this.fileCache.remove((Object)element);
        } else {
            this.childrenCache.remove(element);
        }
    }

    private double getMemoryRatio() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        return maxMemory == Long.MAX_VALUE ? 4.0 : (double)maxMemory / 6.7108864E7;
    }
}

