/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.xtext.ui.wizard.DefaultProjectInfo;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.XtextNewProjectWizard;

public final class NewFooProjectWizard
extends XtextNewProjectWizard {
    private WizardNewProjectCreationPage mainPage;

    public NewFooProjectWizard() {
        super((IProjectCreator)new ProjectCreator());
        this.setWindowTitle("Foo Project");
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("MainPage");
        this.mainPage.setTitle("Create a Foo Project");
        this.mainPage.setDescription("Create a Foo project in the workspace or in an external location.");
        this.addPage((IWizardPage)this.mainPage);
    }

    protected IProjectInfo getProjectInfo() {
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.setProjectName(this.mainPage.getProjectName());
        if (!this.mainPage.useDefaults()) {
            projectInfo.setLocation(this.mainPage.getLocationURI());
        }
        return projectInfo;
    }

    private static class ProjectCreator
    implements IProjectCreator {
        private ProjectInfo projectInfo;

        private ProjectCreator() {
        }

        public void setProjectInfo(IProjectInfo projectInfo) {
            this.projectInfo = (ProjectInfo)projectInfo;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            IFooProject fooProject = FooModelCore.getFooModel().getFooProject(this.projectInfo.getProjectName());
            try {
                fooProject.create(this.projectInfo.getLocation(), monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }

        public IFile getResult() {
            return null;
        }
    }

    private static class ProjectInfo
    extends DefaultProjectInfo {
        private URI location;

        private ProjectInfo() {
        }

        public URI getLocation() {
            return this.location;
        }

        public void setLocation(URI location) {
            this.location = location;
        }
    }
}

