/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IField;
import org.eclipse.handly.examples.javamodel.IImportContainer;
import org.eclipse.handly.examples.javamodel.IImportDeclaration;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IMember;
import org.eclipse.handly.examples.javamodel.IMethod;
import org.eclipse.handly.examples.javamodel.IPackageDeclaration;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.examples.javamodel.IType;
import org.eclipse.handly.internal.examples.javamodel.ui.Activator;
import org.eclipse.handly.internal.examples.javamodel.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.handly.internal.examples.javamodel.ui.util.JavaFlags;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class JavaElementComparator
extends ViewerComparator {
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int COMPILATIONUNITS = 4;
    private static final int RESOURCEFOLDERS = 7;
    private static final int RESOURCES = 8;
    private static final int PACKAGE_DECL = 10;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int MEMBERSOFFSET = 15;
    private static final int JAVAELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache memberOrderCache = Activator.getMemberOrderPreferenceCache();

    public int category(Object element) {
        block28: {
            block27: {
                block20: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            if (!(element instanceof IJavaElement)) break block20;
                                            if (element instanceof IMethod) {
                                                IMethod method = (IMethod)element;
                                                if (method.isConstructor()) {
                                                    return this.getMemberCategory(1);
                                                }
                                                int flags = method.getFlags();
                                                if (Flags.isStatic((int)flags)) {
                                                    return this.getMemberCategory(7);
                                                }
                                                return this.getMemberCategory(2);
                                            }
                                            if (element instanceof IField) {
                                                int flags = ((IField)element).getFlags();
                                                if (Flags.isEnum((int)flags)) {
                                                    return this.getMemberCategory(8);
                                                }
                                                if (Flags.isStatic((int)flags)) {
                                                    return this.getMemberCategory(5);
                                                }
                                                return this.getMemberCategory(3);
                                            }
                                            if (element instanceof IType) {
                                                return this.getMemberCategory(0);
                                            }
                                            if (!(element instanceof IPackageDeclaration)) break block21;
                                            return 10;
                                        }
                                        if (!(element instanceof IImportContainer)) break block22;
                                        return 11;
                                    }
                                    if (!(element instanceof IImportDeclaration)) break block23;
                                    return 12;
                                }
                                if (!(element instanceof IPackageFragment)) break block24;
                                return 3;
                            }
                            if (!(element instanceof IPackageFragmentRoot)) break block25;
                            return 2;
                        }
                        if (!(element instanceof IJavaProject)) break block26;
                        return 1;
                    }
                    if (element instanceof ICompilationUnit) {
                        return 4;
                    }
                    return 50;
                }
                if (!(element instanceof IFile)) break block27;
                return 8;
            }
            if (!(element instanceof IProject)) break block28;
            return 1;
        }
        try {
            if (element instanceof IContainer) {
                return 7;
            }
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        return 51;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof IMember && this.memberOrderCache.isSortByVisibility()) {
            try {
                int flags1 = JavaFlags.getVisibilityCode((IMember)e1);
                int flags2 = JavaFlags.getVisibilityCode((IMember)e2);
                int vis = this.memberOrderCache.getVisibilityIndex(flags1) - this.memberOrderCache.getVisibilityIndex(flags2);
                if (vis != 0) {
                    return vis;
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        }
        return super.compare(viewer, e1, e2);
    }

    private int getMemberCategory(int kind) {
        int offset = this.memberOrderCache.getCategoryIndex(kind);
        return offset + 15;
    }
}

