/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.JavaModelCore;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PersistableJavaElementFactory
implements IElementFactory,
IPersistableElement {
    private static final String KEY = "elementID";
    private static final String FACTORY_ID = "org.eclipse.handly.examples.javamodel.ui.PersistableJavaElementFactory";
    private IJavaElement element;

    public PersistableJavaElementFactory() {
    }

    public PersistableJavaElementFactory(IJavaElement element) {
        this.element = element;
    }

    public IAdaptable createElement(IMemento memento) {
        String value = memento.getString(KEY);
        if (value != null) {
            IPath path = Path.fromPortableString((String)value);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null) {
                return JavaModelCore.create((IResource)resource);
            }
        }
        return null;
    }

    public void saveState(IMemento memento) {
        if (this.element.getAncestor(ICompilationUnit.class) != null) {
            return;
        }
        memento.putString(KEY, this.element.getPath().toPortableString());
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }
}

