/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel.ui.filters;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.IField;
import org.eclipse.handly.examples.javamodel.IMember;
import org.eclipse.handly.examples.javamodel.IType;
import org.eclipse.handly.internal.examples.javamodel.ui.Activator;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class NonPublicMemberFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IMember) {
            try {
                IMember member = (IMember)element;
                int flags = member.getFlags();
                if (!(Flags.isPublic((int)flags) || NonPublicMemberFilter.isMemberInInterfaceOrAnnotation(member) || NonPublicMemberFilter.isTopLevelType(member) || NonPublicMemberFilter.isEnumConstant(member))) {
                    return false;
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        }
        return true;
    }

    private static boolean isMemberInInterfaceOrAnnotation(IMember member) throws CoreException {
        IType type = member.getDeclaringType();
        return type != null && type.isInterface();
    }

    private static boolean isTopLevelType(IMember member) {
        return member.getDeclaringType() == null;
    }

    private static boolean isEnumConstant(IMember member) throws CoreException {
        return member instanceof IField && ((IField)member).isEnumConstant();
    }
}

