/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.examples.javamodel;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;

public interface IJavaElement
extends IElement,
IAdaptable {
    default public String getElementName() {
        return Elements.getName((IElement)this);
    }

    default public IJavaElement getParent() {
        return (IJavaElement)Elements.getParent((IElement)this);
    }

    default public IJavaModel getJavaModel() {
        return (IJavaModel)Elements.getRoot((IElement)this);
    }

    default public <T extends IJavaElement> T getAncestor(Class<T> ancestorType) {
        return (T)((IJavaElement)Elements.getAncestor((IElement)this, ancestorType));
    }

    default public IResource getResource() {
        return Elements.getResource((IElement)this);
    }

    default public IPath getPath() {
        IResource resource = this.getResource();
        if (resource != null) {
            return resource.getFullPath();
        }
        throw new AssertionError((Object)"Please override the default implementation of this method");
    }

    default public boolean exists() {
        return Elements.exists((IElement)this);
    }

    default public IJavaElement[] getChildren() throws CoreException {
        IElement[] src = Elements.getChildren((IElement)this);
        int length = src.length;
        IJavaElement[] dest = new IJavaElement[length];
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    default public <T extends IJavaElement> T[] getChildren(Class<T> childType) throws CoreException {
        return (IJavaElement[])Elements.getChildren((IElement)this, childType);
    }
}

