/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.SimpleSourceFile;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.util.Property;

public class OutOfSyncSourceFileTest
extends WorkspaceTestCase {
    private IEclipsePreferences preferences;
    private boolean autoRefresh;
    private boolean lightweightAutoRefresh;
    private IFile file;
    private File localFile;
    private SourceFile sourceFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.preferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        this.autoRefresh = this.preferences.getBoolean("refresh.enabled", false);
        this.lightweightAutoRefresh = this.preferences.getBoolean("refresh.lightweight.enabled", true);
        this.preferences.putBoolean("refresh.enabled", false);
        this.preferences.putBoolean("refresh.lightweight.enabled", false);
        this.file = this.setUpProject("Test001").getFile("file.txt");
        this.localFile = this.file.getLocation().toFile();
        this.sourceFile = new SimpleSourceFile(null, this.file, null);
    }

    protected void tearDown() throws Exception {
        if (this.preferences != null) {
            this.preferences.putBoolean("refresh.enabled", this.autoRefresh);
            this.preferences.putBoolean("refresh.lightweight.enabled", this.lightweightAutoRefresh);
        }
        super.tearDown();
    }

    public void testInSync() throws Exception {
        this.sourceFile.hBuildStructure(Contexts.of((Property)Element.NEW_ELEMENTS, new HashMap()), (IProgressMonitor)new NullProgressMonitor());
    }

    public void testOutOfSync() throws Exception {
        OutOfSyncSourceFileTest.assertTrue((boolean)this.localFile.setLastModified(this.localFile.lastModified() + 1000L));
        this.sourceFile.hBuildStructure(Contexts.of((Property)Element.NEW_ELEMENTS, new HashMap()), (IProgressMonitor)new NullProgressMonitor());
    }
}

