/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.util.AdapterUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelper
implements ILinkHelper {
    private IInputElementProvider inputElementProvider;

    public void setInputElementProvider(IInputElementProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.inputElementProvider = provider;
    }

    public IStructuredSelection findSelection(IEditorInput editorInput) {
        IElement inputElement = this.inputElementProvider.getElement(editorInput);
        if (inputElement != null) {
            IElement element;
            IStructuredSelection currentSelection;
            IViewPart navigatorView = this.getNavigatorView();
            if (navigatorView != null && (currentSelection = (IStructuredSelection)navigatorView.getSite().getSelectionProvider().getSelection()) != null && currentSelection.size() == 1 && (element = (IElement)AdapterUtil.getAdapter((Object)currentSelection.getFirstElement(), IElement.class, (boolean)true)) != null && LinkHelper.check(inputElement, element)) {
                return currentSelection;
            }
            return new StructuredSelection((Object)inputElement);
        }
        IFile file = (IFile)AdapterUtil.getAdapter((Object)editorInput, IFile.class, (boolean)true);
        if (file != null) {
            return new StructuredSelection((Object)file);
        }
        return null;
    }

    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        IEditorPart editor;
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        EditorUtility editorUtility = this.getEditorUtility();
        IEditorReference reference = editorUtility.findEditor(page, element);
        if (reference != null && (editor = reference.getEditor(true)) != null) {
            page.bringToTop((IWorkbenchPart)editor);
            editorUtility.revealElement(editor, element);
        }
    }

    protected IViewPart getNavigatorView() {
        return null;
    }

    protected IInputElementProvider getInputElementProvider() {
        return this.inputElementProvider;
    }

    protected EditorUtility getEditorUtility() {
        return EditorUtility.DEFAULT;
    }

    private static boolean check(IElement ancestor, IElement descendent) {
        descendent = Elements.getParent((IElement)descendent);
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = Elements.getParent((IElement)descendent);
        }
        return false;
    }
}

