/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;

public abstract class ElementChangeListenerContribution
extends OutlineContribution {
    private IElementChangeListener listener = new IElementChangeListener(){

        public void elementChanged(IElementChangeEvent event) {
            if (ElementChangeListenerContribution.this.affects(event, ElementChangeListenerContribution.this.getOutlinePage().getTreeViewer().getInput())) {
                ElementChangeListenerContribution.this.elementChanged(event);
            }
        }
    };

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        this.addElementChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        if (this.getOutlinePage() != null) {
            this.removeElementChangeListener(this.listener);
        }
        super.dispose();
    }

    protected boolean affects(IElementChangeEvent event, Object inputElement) {
        IElement element = this.getContentAdapter().adapt(inputElement);
        if (element != null) {
            return this.affects(event.getDelta(), element);
        }
        return false;
    }

    protected boolean affects(IElementDelta delta, IElement element) {
        IElementDelta[] children;
        if (ElementDeltas.getElement((IElementDelta)delta).equals((Object)element)) {
            return true;
        }
        IElementDelta[] iElementDeltaArray = children = ElementDeltas.getAffectedChildren((IElementDelta)delta);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDelta child = iElementDeltaArray[n2];
            if (this.affects(child, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract void addElementChangeListener(IElementChangeListener var1);

    protected abstract void removeElementChangeListener(IElementChangeListener var1);

    protected abstract void elementChanged(IElementChangeEvent var1);

    protected IContentAdapter getContentAdapter() {
        ICommonOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage instanceof IContentAdapterProvider) {
            return ((IContentAdapterProvider)outlinePage).getContentAdapter();
        }
        return NullContentAdapter.INSTANCE;
    }
}

