/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.workingset;

import org.eclipse.core.resources.IResource;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.ide.ResourceUtil;

public abstract class AbstractContainmentAdapter
implements IContainmentAdapter {
    public boolean contains(Object workingSetElement, Object element, int flags) {
        IElement hWorkingSetElement = this.getContentAdapter().adapt(workingSetElement);
        if (hWorkingSetElement == null || element == null) {
            return false;
        }
        IResource resource = null;
        IElement hElement = this.getContentAdapter().adapt(element);
        if (hElement == null && (resource = ResourceUtil.getResource((Object)element)) != null) {
            hElement = this.getElementFor(resource);
        }
        if (hElement != null) {
            return this.contains(hWorkingSetElement, hElement, flags);
        }
        if (resource != null) {
            return this.contains(hWorkingSetElement, resource, flags);
        }
        return false;
    }

    protected abstract IElement getElementFor(IResource var1);

    protected IContentAdapter getContentAdapter() {
        return NullContentAdapter.INSTANCE;
    }

    protected boolean contains(IElement workingSetElement, IElement element, int flags) {
        if (AbstractContainmentAdapter.checkContext(flags) && workingSetElement.equals((Object)element)) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfChild(flags) && workingSetElement.equals((Object)Elements.getParent((IElement)element))) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfDescendant(flags) && this.check(workingSetElement, element)) {
            return true;
        }
        return AbstractContainmentAdapter.checkIfAncestor(flags) && this.check(element, workingSetElement);
    }

    protected boolean check(IElement ancestor, IElement descendent) {
        descendent = Elements.getParent((IElement)descendent);
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = Elements.getParent((IElement)descendent);
        }
        return false;
    }

    protected boolean contains(IElement workingSetElement, IResource resource, int flags) {
        IResource workingSetResource = Elements.getResource((IElement)workingSetElement);
        if (workingSetResource == null) {
            return false;
        }
        if (AbstractContainmentAdapter.checkContext(flags) && workingSetResource.equals((Object)resource)) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfChild(flags) && workingSetResource.equals((Object)resource.getParent())) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfDescendant(flags) && this.check(workingSetResource, resource)) {
            return true;
        }
        return AbstractContainmentAdapter.checkIfAncestor(flags) && this.check(resource, workingSetResource);
    }

    protected boolean check(IResource ancestor, IResource descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    protected static boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }

    protected static boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    protected static boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    protected static boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }
}

