/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.ElementDelta;

public class Body {
    public static final IElement[] NO_CHILDREN = new IElement[0];
    private volatile IElement[] children = NO_CHILDREN;

    public IElement[] getChildren() {
        return this.children;
    }

    public void setChildren(IElement[] children) {
        if (children == null) {
            throw new IllegalArgumentException();
        }
        this.children = children;
    }

    public void addChild(IElement child) {
        IElement[] oldChildren = this.children;
        int length = oldChildren.length;
        if (length == 0) {
            this.children = new IElement[]{child};
        } else {
            int i = 0;
            while (i < length) {
                if (oldChildren[i].equals(child)) {
                    return;
                }
                ++i;
            }
            IElement[] newChildren = new IElement[length + 1];
            System.arraycopy(oldChildren, 0, newChildren, 0, length);
            newChildren[length] = child;
            this.children = newChildren;
        }
    }

    public void removeChild(IElement child) {
        IElement[] oldChildren = this.children;
        int i = 0;
        int length = oldChildren.length;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                if (length == 1) {
                    this.children = NO_CHILDREN;
                    break;
                }
                IElement[] newChildren = new IElement[length - 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, i);
                if (i < length - 1) {
                    System.arraycopy(oldChildren, i + 1, newChildren, i, length - i - 1);
                }
                this.children = newChildren;
                break;
            }
            ++i;
        }
    }

    public void findContentChange(Body oldBody, IElement element, ElementDelta.Builder builder) {
    }
}

