/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.util.LruCache;
import org.eclipse.handly.util.OverflowingLruCache;
import org.eclipse.handly.util.ToStringOptions;

public class ElementCache
extends OverflowingLruCache<IElement, Object> {
    private IElement spaceLimitParent = null;

    public ElementCache(int spaceLimit) {
        this(spaceLimit, 0);
    }

    protected ElementCache(int spaceLimit, int overflow) {
        super(spaceLimit, overflow);
    }

    public void ensureSpaceLimit(Object body, IElement parent) {
        int childCount = this.getChildCount(parent, body);
        int spaceNeeded = 1 + (int)((1.0 + this.loadFactor) * (double)(childCount + this.overflow));
        if (this.spaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    public void resetSpaceLimit(int defaultLimit, IElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }

    protected int getChildCount(IElement element, Object body) {
        return ((Element)element).hChildren(body).length;
    }

    @Override
    protected boolean close(LruCache.LruCacheEntry<IElement, Object> entry) {
        return ((Element)entry.key).hClose();
    }

    @Override
    protected OverflowingLruCache<IElement, Object> newInstance(int spaceLimit, int overflow) {
        return new ElementCache(spaceLimit, overflow);
    }

    @Override
    protected String toStringContents() {
        StringBuilder result = new StringBuilder();
        LruCache.LruCacheEntry entry = this.entryQueue;
        while (entry != null) {
            result.append(Elements.toString((IElement)entry.key, Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM)));
            ToStringOptions.INDENT_POLICY.defaultValue().appendLine(result);
            entry = entry.next;
        }
        return result.toString();
    }
}

