/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.IElementDeltaImpl;
import org.eclipse.handly.util.IndentPolicy;
import org.eclipse.handly.util.ToStringOptions;

public class ElementDelta
implements IElementDeltaImpl {
    private static final ElementDelta[] NO_CHILDREN = new ElementDelta[0];
    private final IElement element;
    private int kind;
    private long flags;
    private IElement movedFromElement;
    private IElement movedToElement;
    private ElementDelta[] affectedChildren = NO_CHILDREN;
    private Map<Key, Integer> childIndex;
    private IMarkerDelta[] markerDeltas;
    private IResourceDelta[] resourceDeltas;
    private int resourceDeltasCounter;

    public ElementDelta(IElement element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
    }

    @Override
    public final IElement hElement() {
        return this.element;
    }

    @Override
    public final int hKind() {
        return this.kind;
    }

    @Override
    public final long hFlags() {
        return this.flags;
    }

    public final ElementDelta[] hAffectedChildren() {
        return this.affectedChildren;
    }

    public final ElementDelta[] hAddedChildren() {
        return this.getChildrenOfKind(1);
    }

    public final ElementDelta[] hRemovedChildren() {
        return this.getChildrenOfKind(2);
    }

    public final ElementDelta[] hChangedChildren() {
        return this.getChildrenOfKind(3);
    }

    @Override
    public final IElement hMovedFromElement() {
        return this.movedFromElement;
    }

    @Override
    public final IElement hMovedToElement() {
        return this.movedToElement;
    }

    @Override
    public final IMarkerDelta[] hMarkerDeltas() {
        return this.markerDeltas;
    }

    @Override
    public final IResourceDelta[] hResourceDeltas() {
        if (this.resourceDeltas != null && this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    public boolean hIsEmpty() {
        return this.kind == 0;
    }

    public ElementDelta hDeltaFor(IElement element) {
        if (element == null) {
            return null;
        }
        if (Elements.equalsAndSameParent(this.element, element)) {
            return this;
        }
        return this.findDescendant(new Key(element));
    }

    public String toString() {
        return this.hToString(Contexts.EMPTY_CONTEXT);
    }

    @Override
    public String hToString(IContext context) {
        StringBuilder builder = new StringBuilder();
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int indentLevel = context.getOrDefault(ToStringOptions.INDENT_LEVEL);
        indentPolicy.appendIndent(builder, indentLevel);
        builder.append(Elements.toString(this.element, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.SHORT), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
        builder.append('[');
        this.hToStringKind(builder, context);
        builder.append("]: {");
        this.hToStringFlags(builder, context);
        builder.append('}');
        ToStringOptions.FormatStyle style = context.getOrDefault(ToStringOptions.FORMAT_STYLE);
        if (style == ToStringOptions.FormatStyle.FULL || style == ToStringOptions.FormatStyle.LONG) {
            if (this.affectedChildren.length > 0) {
                indentPolicy.appendLine(builder);
                this.hToStringChildren(builder, Contexts.with(Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(indentLevel + 1)), context));
            }
            if (this.resourceDeltasCounter > 0) {
                indentPolicy.appendLine(builder);
                this.hToStringResourceDeltas(builder, Contexts.with(Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(indentLevel + 1)), context));
            }
        }
        return builder.toString();
    }

    protected void hToStringChildren(StringBuilder builder, IContext context) {
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int i = 0;
        while (i < this.affectedChildren.length) {
            if (i > 0) {
                indentPolicy.appendLine(builder);
            }
            builder.append(this.affectedChildren[i].hToString(context));
            ++i;
        }
    }

    protected void hToStringResourceDeltas(StringBuilder builder, IContext context) {
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int indentLevel = context.getOrDefault(ToStringOptions.INDENT_LEVEL);
        int i = 0;
        while (i < this.resourceDeltasCounter) {
            if (i > 0) {
                indentPolicy.appendLine(builder);
            }
            indentPolicy.appendIndent(builder, indentLevel);
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            builder.append("ResourceDelta(" + resourceDelta.getFullPath() + ')');
            builder.append('[');
            switch (resourceDelta.getKind()) {
                case 1: {
                    builder.append('+');
                    break;
                }
                case 2: {
                    builder.append('-');
                    break;
                }
                case 4: {
                    builder.append('*');
                    break;
                }
                default: {
                    builder.append('?');
                }
            }
            builder.append(']');
            ++i;
        }
    }

    protected void hToStringKind(StringBuilder builder, IContext context) {
        switch (this.kind) {
            case 1: {
                builder.append('+');
                break;
            }
            case 2: {
                builder.append('-');
                break;
            }
            case 3: {
                builder.append('*');
                break;
            }
            default: {
                builder.append('?');
            }
        }
    }

    protected boolean hToStringFlags(StringBuilder builder, IContext context) {
        boolean prev = false;
        if ((this.flags & 2L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("CHILDREN");
            prev = true;
        }
        if ((this.flags & 1L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("CONTENT");
            prev = true;
        }
        if ((this.flags & 4L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("MOVED_FROM(");
            builder.append(Elements.toString(this.movedFromElement, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
            builder.append(')');
            prev = true;
        }
        if ((this.flags & 8L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("MOVED_TO(");
            builder.append(Elements.toString(this.movedToElement, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
            builder.append(')');
            prev = true;
        }
        if ((this.flags & 0x10L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("REORDERED");
            prev = true;
        }
        if ((this.flags & 0x20L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("FINE GRAINED");
            prev = true;
        }
        if ((this.flags & 0x40L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("OPEN");
            prev = true;
        }
        if ((this.flags & 0x80L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("DESCRIPTION");
            prev = true;
        }
        if ((this.flags & 0x100L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("WORKING COPY");
            prev = true;
        }
        if ((this.flags & 0x200L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("UNDERLYING_RESOURCE");
            prev = true;
        }
        if ((this.flags & 0x400L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("MARKERS");
            prev = true;
        }
        if ((this.flags & 0x800L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("SYNC");
            prev = true;
        }
        return prev;
    }

    protected ElementDelta hNewDelta(IElement element) {
        Factory factory = Elements.getModel(element).getModelContext().get(Factory.class);
        if (factory != null) {
            return factory.newDelta(element);
        }
        return new ElementDelta(element);
    }

    protected boolean hNeedsChildIndex() {
        return this.affectedChildren.length >= 3;
    }

    void hClearAffectedChildren() {
        this.affectedChildren = NO_CHILDREN;
        this.childIndex = null;
    }

    private ElementDelta[] getChildrenOfKind(int kind) {
        int length = this.affectedChildren.length;
        if (length == 0) {
            return NO_CHILDREN;
        }
        ArrayList<ElementDelta> children = new ArrayList<ElementDelta>(length);
        ElementDelta[] elementDeltaArray = this.affectedChildren;
        int n = this.affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDelta child = elementDeltaArray[n2];
            if (child.kind == kind) {
                children.add(child);
            }
            ++n2;
        }
        return children.toArray(NO_CHILDREN);
    }

    private ElementDelta findDescendant(Key key) {
        if (this.affectedChildren.length == 0) {
            return null;
        }
        Integer index = this.indexOfChild(key);
        if (index != null) {
            return this.affectedChildren[index];
        }
        ElementDelta[] elementDeltaArray = this.affectedChildren;
        int n = this.affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDelta child = elementDeltaArray[n2];
            ElementDelta delta = child.findDescendant(key);
            if (delta != null) {
                return delta;
            }
            ++n2;
        }
        return null;
    }

    private Integer indexOfChild(Key key) {
        int length = this.affectedChildren.length;
        if (!this.hNeedsChildIndex()) {
            int i = 0;
            while (i < length) {
                if (Elements.equalsAndSameParent(key.element, this.affectedChildren[i].element)) {
                    return i;
                }
                ++i;
            }
            return null;
        }
        if (this.childIndex == null) {
            this.childIndex = new HashMap<Key, Integer>();
            int i = 0;
            while (i < length) {
                this.childIndex.put(new Key(this.affectedChildren[i].element), i);
                ++i;
            }
        }
        return this.childIndex.get(key);
    }

    private void addAffectedChild(ElementDelta child) {
        Key key;
        Integer index;
        if (child == null) {
            throw new IllegalArgumentException();
        }
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                this.flags |= 2L;
                break;
            }
            default: {
                this.kind = 3;
                this.flags |= 2L;
            }
        }
        if (this.element instanceof ISourceFile) {
            this.flags |= 0x20L;
        }
        if ((index = this.indexOfChild(key = new Key(child.element))) == null) {
            this.addNewChild(child);
        } else {
            ElementDelta existingChild = this.affectedChildren[index];
            switch (existingChild.kind) {
                case 1: {
                    switch (child.kind) {
                        case 1: 
                        case 3: {
                            return;
                        }
                        case 2: {
                            this.removeExistingChild(key, index);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.kind) {
                        case 1: {
                            child.kind = 3;
                            this.affectedChildren[index.intValue()] = child;
                            return;
                        }
                        case 2: 
                        case 3: {
                            return;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (child.kind) {
                        case 1: 
                        case 2: {
                            this.affectedChildren[index.intValue()] = child;
                            return;
                        }
                        case 3: {
                            ElementDelta[] elementDeltaArray = child.affectedChildren;
                            int n = child.affectedChildren.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ElementDelta childsChild = elementDeltaArray[n2];
                                existingChild.addAffectedChild(childsChild);
                                ++n2;
                            }
                            boolean childHadContentFlag = (child.flags & 1L) != 0L;
                            boolean existingChildHadChildrenFlag = (existingChild.flags & 2L) != 0L;
                            existingChild.flags |= child.flags;
                            if (childHadContentFlag && existingChildHadChildrenFlag) {
                                existingChild.flags &= 0xFFFFFFFFFFFFFFFEL;
                            }
                            if (child.markerDeltas != null) {
                                if (existingChild.markerDeltas != null) {
                                    throw new AssertionError((Object)"Merge of marker deltas is not supported");
                                }
                                existingChild.markerDeltas = child.markerDeltas;
                            }
                            if (child.resourceDeltas != null) {
                                if (existingChild.resourceDeltas != null) {
                                    throw new AssertionError((Object)"Merge of resource deltas is not supported");
                                }
                                existingChild.resourceDeltas = child.resourceDeltas;
                                existingChild.resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    this.affectedChildren[index.intValue()] = child;
                    child.flags |= existingChild.flags;
                }
            }
        }
    }

    private void addNewChild(ElementDelta child) {
        this.affectedChildren = ElementDelta.growAndAddToArray(this.affectedChildren, child);
        if (this.childIndex != null) {
            this.childIndex.put(new Key(child.element), this.affectedChildren.length - 1);
        }
    }

    private void removeExistingChild(Key key, int index) {
        this.affectedChildren = ElementDelta.removeAndShrinkArray(this.affectedChildren, index);
        if (this.childIndex != null) {
            if (!this.hNeedsChildIndex()) {
                this.childIndex = null;
            } else {
                this.childIndex.remove(key);
                int i = index;
                while (i < this.affectedChildren.length) {
                    this.childIndex.put(new Key(this.affectedChildren[i].element), i);
                    ++i;
                }
            }
        }
    }

    private void setMarkerDeltas(IMarkerDelta[] markerDeltas) {
        if (markerDeltas == null || markerDeltas.length == 0) {
            throw new IllegalArgumentException();
        }
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                this.flags |= 0x400L;
                break;
            }
            default: {
                this.kind = 3;
                this.flags |= 0x400L;
            }
        }
        this.markerDeltas = markerDeltas;
    }

    private void addResourceDelta(IResourceDelta child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                this.flags |= 1L;
                break;
            }
            default: {
                this.kind = 3;
                this.flags |= 1L;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    private static ElementDelta[] growAndAddToArray(ElementDelta[] array, ElementDelta addition) {
        ElementDelta[] result = new ElementDelta[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = addition;
        return result;
    }

    private static ElementDelta[] removeAndShrinkArray(ElementDelta[] array, int index) {
        int rest;
        ElementDelta[] result = new ElementDelta[array.length - 1];
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if ((rest = array.length - index - 1) > 0) {
            System.arraycopy(array, index + 1, result, index, rest);
        }
        return result;
    }

    public static class Builder {
        private final ElementDelta rootDelta;

        public Builder(ElementDelta rootDelta) {
            if (rootDelta == null) {
                throw new IllegalArgumentException();
            }
            this.rootDelta = rootDelta;
        }

        public ElementDelta getDelta() {
            return this.rootDelta;
        }

        public boolean isEmptyDelta() {
            return this.rootDelta.hIsEmpty();
        }

        public ElementDelta findDelta(IElement element) {
            return this.rootDelta.hDeltaFor(element);
        }

        public Builder added(IElement element) {
            return this.added(element, 0L);
        }

        public Builder added(IElement element, long flags) {
            this.insert(this.newAdded(element, flags));
            return this;
        }

        public Builder removed(IElement element) {
            return this.removed(element, 0L);
        }

        public Builder removed(IElement element, long flags) {
            ElementDelta delta = this.rootDelta.hNewDelta(element);
            delta.flags = flags;
            this.insert(delta);
            ElementDelta actualDelta = this.findDelta(element);
            if (actualDelta != null) {
                actualDelta.kind = 2;
                actualDelta.flags = flags;
                actualDelta.hClearAffectedChildren();
            }
            return this;
        }

        public Builder changed(IElement element, long flags) {
            this.insert(this.newChanged(element, flags));
            return this;
        }

        public Builder movedFrom(IElement movedFromElement, IElement movedToElement) {
            this.insert(this.newMovedFrom(movedFromElement, movedToElement));
            return this;
        }

        public Builder movedTo(IElement movedToElement, IElement movedFromElement) {
            this.insert(this.newMovedTo(movedToElement, movedFromElement));
            return this;
        }

        public Builder markersChanged(IElement element, IMarkerDelta[] markerDeltas) {
            ElementDelta delta = this.findDelta(element);
            if (delta == null) {
                this.changed(element, 0L);
                delta = this.findDelta(element);
            }
            delta.setMarkerDeltas(markerDeltas);
            return this;
        }

        public Builder addResourceDelta(IElement element, IResourceDelta resourceDelta) {
            ElementDelta delta = this.findDelta(element);
            if (delta == null) {
                this.changed(element, 0L);
                delta = this.findDelta(element);
            }
            delta.addResourceDelta(resourceDelta);
            return this;
        }

        protected void insert(ElementDelta delta) {
            if (delta == null) {
                throw new IllegalArgumentException();
            }
            if (!Elements.equalsAndSameParent(delta.element, this.rootDelta.element)) {
                this.rootDelta.addAffectedChild(this.createDeltaTree(delta));
            } else {
                this.rootDelta.kind = delta.kind;
                this.rootDelta.flags = delta.flags;
                this.rootDelta.movedToElement = delta.movedToElement;
                this.rootDelta.movedFromElement = delta.movedFromElement;
            }
        }

        private ElementDelta createDeltaTree(ElementDelta delta) {
            ElementDelta childDelta = delta;
            List<IElement> ancestors = this.getAncestors(delta.element);
            if (ancestors == null) {
                IContext context = Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.SHORT);
                throw new IllegalArgumentException(MessageFormat.format("Delta {0} cannot be rooted under {1}", delta.hToString(context), this.rootDelta.hToString(context)));
            }
            for (IElement ancestor : ancestors) {
                ElementDelta ancestorDelta = this.rootDelta.hNewDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
            }
            return childDelta;
        }

        private List<IElement> getAncestors(IElement child) {
            IElement parent = Elements.getParent(child);
            if (parent == null) {
                return null;
            }
            ArrayList<IElement> parents = new ArrayList<IElement>();
            while (!parent.equals(this.rootDelta.element)) {
                parents.add(parent);
                parent = Elements.getParent(parent);
                if (parent != null) continue;
                return null;
            }
            parents.trimToSize();
            return parents;
        }

        private ElementDelta newAdded(IElement element, long flags) {
            ElementDelta delta = this.rootDelta.hNewDelta(element);
            delta.kind = 1;
            delta.flags = flags;
            return delta;
        }

        private ElementDelta newRemoved(IElement element, long flags) {
            ElementDelta delta = this.rootDelta.hNewDelta(element);
            delta.kind = 2;
            delta.flags = flags;
            return delta;
        }

        private ElementDelta newChanged(IElement element, long flags) {
            ElementDelta delta = this.rootDelta.hNewDelta(element);
            delta.kind = 3;
            delta.flags = flags;
            return delta;
        }

        private ElementDelta newMovedFrom(IElement movedFromElement, IElement movedToElement) {
            ElementDelta delta = this.newRemoved(movedFromElement, 8L);
            if (movedToElement == null) {
                throw new IllegalArgumentException();
            }
            delta.movedToElement = movedToElement;
            return delta;
        }

        private ElementDelta newMovedTo(IElement movedToElement, IElement movedFromElement) {
            ElementDelta delta = this.newAdded(movedToElement, 4L);
            if (movedFromElement == null) {
                throw new IllegalArgumentException();
            }
            delta.movedFromElement = movedFromElement;
            return delta;
        }
    }

    public static interface Factory {
        public ElementDelta newDelta(IElement var1);
    }

    private static class Key {
        public final IElement element;

        public Key(IElement element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            this.element = element;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            return Elements.equalsAndSameParent(this.element, ((Key)obj).element);
        }
    }
}

