/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.DefaultWorkingCopyInfo;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.IBodyCache;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.model.impl.WorkingCopyInfo;

public class ElementManager {
    private static final ISourceFile[] NO_WORKING_COPIES = new ISourceFile[0];
    private IBodyCache cache;
    private ThreadLocal<Map<IElement, Object>> temporaryCache = new ThreadLocal();
    private Map<SourceFile, WorkingCopyInfo> workingCopyInfos = new HashMap<SourceFile, WorkingCopyInfo>();

    public ElementManager(IBodyCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        this.cache = cache;
    }

    public final synchronized ISourceFile[] getWorkingCopies() {
        return this.workingCopyInfos.keySet().toArray(NO_WORKING_COPIES);
    }

    protected void close(IElement element) {
        ((Element)element).hClose(false);
    }

    synchronized Object get(Element element) {
        Object body;
        Map<IElement, Object> tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(element)) != null) {
            return body;
        }
        return this.cache.get(element);
    }

    synchronized Object peek(Element element) {
        Object body;
        Map<IElement, Object> tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(element)) != null) {
            return body;
        }
        return this.cache.peek(element);
    }

    synchronized void put(Element element, Map<IElement, Object> newElements) {
        WorkingCopyInfo info;
        this.remove(element);
        this.cache.putAll(newElements);
        if (element instanceof SourceFile && (info = this.workingCopyInfos.get((SourceFile)element)) != null && !info.created) {
            info.created = true;
        }
    }

    synchronized Object putIfAbsent(Element element, Map<IElement, Object> newElements) {
        Object existingBody = this.cache.peek(element);
        if (existingBody != null) {
            return existingBody;
        }
        this.cache.putAll(newElements);
        return null;
    }

    synchronized void remove(Element element) {
        Object body = this.cache.peek(element);
        if (body != null) {
            element.hRemoving(body);
            IElement[] iElementArray = element.hChildren(body);
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement child = iElementArray[n2];
                this.close(child);
                ++n2;
            }
            this.cache.remove(element);
        }
    }

    Map<IElement, Object> getTemporaryCache() {
        Map<IElement, Object> result = this.temporaryCache.get();
        if (result == null) {
            result = new HashMap<IElement, Object>();
            this.temporaryCache.set(result);
        }
        return result;
    }

    boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    WorkingCopyInfo putWorkingCopyInfoIfAbsent(SourceFile sourceFile, IBuffer buffer, WorkingCopyInfo.Factory factory) {
        WorkingCopyInfo workingCopyInfo;
        if (sourceFile == null) {
            throw new IllegalArgumentException();
        }
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        WorkingCopyInfo info = factory == null ? new DefaultWorkingCopyInfo(sourceFile, buffer) : factory.newWorkingCopyInfo(sourceFile, buffer);
        if (info.refCount != 0) {
            throw new AssertionError();
        }
        if (info.getSourceFile() != sourceFile) {
            throw new AssertionError();
        }
        boolean disposeInfo = true;
        boolean releaseBuffer = false;
        if (info.getBuffer() != buffer) {
            throw new AssertionError();
        }
        buffer.addRef();
        releaseBuffer = true;
        ElementManager elementManager = this;
        synchronized (elementManager) {
            WorkingCopyInfo oldInfo = this.workingCopyInfos.get(sourceFile);
            if (oldInfo != null) {
                ++oldInfo.refCount;
            } else {
                this.workingCopyInfos.put(sourceFile, info);
                info.refCount = 1;
                disposeInfo = false;
                releaseBuffer = false;
            }
            workingCopyInfo = oldInfo;
        }
        try {
            if (disposeInfo) {
                info.dispose();
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        return workingCopyInfo;
        {
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    try {
                        if (disposeInfo) {
                            info.dispose();
                        }
                    }
                    finally {
                        if (releaseBuffer) {
                            buffer.release();
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }

    synchronized WorkingCopyInfo getWorkingCopyInfo(SourceFile sourceFile) {
        WorkingCopyInfo info = this.workingCopyInfos.get(sourceFile);
        if (info != null) {
            ++info.refCount;
        }
        return info;
    }

    synchronized WorkingCopyInfo peekAtWorkingCopyInfo(SourceFile sourceFile) {
        return this.workingCopyInfos.get(sourceFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkingCopyInfo releaseWorkingCopyInfo(SourceFile sourceFile) {
        WorkingCopyInfo infoToDispose = null;
        try {
            ElementManager elementManager = this;
            synchronized (elementManager) {
                WorkingCopyInfo info = this.workingCopyInfos.get(sourceFile);
                if (info != null && --info.refCount == 0) {
                    infoToDispose = info;
                    this.workingCopyInfos.remove(sourceFile);
                    this.remove(sourceFile);
                }
                WorkingCopyInfo workingCopyInfo = info;
                return workingCopyInfo;
            }
        }
        finally {
            if (infoToDispose != null) {
                IBuffer buffer = infoToDispose.getBuffer();
                try {
                    infoToDispose.dispose();
                }
                finally {
                    buffer.release();
                }
            }
        }
    }
}

