/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.impl.ElementChangeListenerList;
import org.eclipse.handly.model.impl.INotificationManager;

public class NotificationManager
implements INotificationManager {
    private final ElementChangeListenerList listenerList = new ElementChangeListenerList();

    public void addElementChangeListener(IElementChangeListener listener) {
        this.listenerList.add(listener, Integer.MAX_VALUE);
    }

    public void addElementChangeListener(IElementChangeListener listener, int eventMask) {
        this.listenerList.add(listener, eventMask);
    }

    public void removeElementChangeListener(IElementChangeListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void fireElementChangeEvent(final IElementChangeEvent event) {
        ElementChangeListenerList.Entry[] entries;
        int eventType = event.getType();
        ElementChangeListenerList.Entry[] entryArray = entries = this.listenerList.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            final ElementChangeListenerList.Entry entry = entryArray[n2];
            if ((eventType & entry.getEventMask()) != 0) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        entry.getListener().elementChanged(event);
                    }
                });
            }
            ++n2;
        }
    }
}

