/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.model.impl.ElementDifferencer;
import org.eclipse.handly.model.impl.INotificationManager;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.handly.model.impl.SourceElement;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.handly.util.ToStringOptions;

public abstract class SourceFile
extends SourceElement
implements ISourceFileImpl {
    public static final Property<IBuffer> WORKING_COPY_BUFFER = Property.get(String.valueOf(SourceFile.class.getName()) + ".workingCopyBuffer", IBuffer.class);
    public static final Property<WorkingCopyInfo.Factory> WORKING_COPY_INFO_FACTORY = Property.get(String.valueOf(SourceFile.class.getName()) + ".workingCopyInfoFactory", WorkingCopyInfo.Factory.class);
    protected static final Property<Object> SOURCE_AST = Property.get(String.valueOf(SourceFile.class.getName()) + ".sourceAst", Object.class);
    protected static final Property<String> SOURCE_CONTENTS = Property.get(String.valueOf(SourceFile.class.getName()) + ".sourceContents", String.class);
    protected static final Property<ISnapshot> SOURCE_SNAPSHOT = Property.get(String.valueOf(SourceFile.class.getName()) + ".sourceSnapshot", ISnapshot.class);
    protected static final Property<Boolean> REBUILD_STRUCTURE_IF_FORCED = Property.get(String.valueOf(SourceFile.class.getName()) + ".rebuildStructureIfForced", Boolean.class).withDefault(false);
    static final Property<Boolean> RECONCILING_FORCED = Property.get(String.valueOf(SourceFile.class.getName()) + ".reconcilingForced", Boolean.class).withDefault(false);
    private static final ThreadLocal<SourceFile> CURRENTLY_RECONCILED = new ThreadLocal();

    public SourceFile(Element parent, String name) {
        super(parent, name);
    }

    @Override
    public final IBuffer hBuffer(IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        try {
            IBuffer iBuffer;
            WorkingCopyInfo info = this.hAcquireExistingWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (info == null) {
                IBuffer iBuffer2 = this.hFileBuffer(context, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                return iBuffer2;
            }
            try {
                IBuffer buffer = info.getBuffer();
                buffer.addRef();
                iBuffer = buffer;
                this.hReleaseWorkingCopy();
            }
            catch (Throwable throwable) {
                this.hReleaseWorkingCopy();
                throw throwable;
            }
            return iBuffer;
        }
        finally {
            monitor.done();
        }
    }

    public final WorkingCopyInfo hBecomeWorkingCopy(final IContext context, final IProgressMonitor monitor) throws CoreException {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        final IBuffer buffer = context.get(WORKING_COPY_BUFFER);
        if (buffer == null) {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IBuffer defaultBuffer = this.hFileBuffer(context, monitor);){
                return this.hBecomeWorkingCopy(Contexts.with(Contexts.of(WORKING_COPY_BUFFER, defaultBuffer), context), monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        WorkingCopyProvider provider = new WorkingCopyProvider(this){

            @Override
            protected WorkingCopyInfo doAcquireWorkingCopy() {
                return this.hElementManager().putWorkingCopyInfoIfAbsent(this, buffer, context.get(WORKING_COPY_INFO_FACTORY));
            }

            @Override
            protected boolean isCanceled() {
                if (monitor == null) {
                    return false;
                }
                return monitor.isCanceled();
            }
        };
        WorkingCopyInfo oldInfo = provider.acquireWorkingCopy();
        if (oldInfo == null) {
            boolean success = false;
            try {
                WorkingCopyInfo newInfo = this.hElementManager().peekAtWorkingCopyInfo(this);
                newInfo.initTask.execute(context, monitor);
                success = true;
            }
            finally {
                if (!success) {
                    this.hReleaseWorkingCopy();
                }
            }
        }
        return oldInfo;
    }

    public final WorkingCopyInfo hAcquireExistingWorkingCopy(final IProgressMonitor monitor) {
        WorkingCopyProvider provider = new WorkingCopyProvider(this){

            @Override
            protected WorkingCopyInfo doAcquireWorkingCopy() {
                return this.hElementManager().getWorkingCopyInfo(this);
            }

            @Override
            protected boolean isCanceled() {
                if (monitor == null) {
                    return false;
                }
                return monitor.isCanceled();
            }
        };
        return provider.acquireWorkingCopy();
    }

    public final boolean hReleaseWorkingCopy() {
        WorkingCopyInfo info = this.hElementManager().releaseWorkingCopyInfo(this);
        if (info == null) {
            throw new IllegalStateException("Not a working copy: " + this.hToString(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM)));
        }
        if (info.isDisposed() && info.created) {
            this.hWorkingCopyModeChanged();
            return true;
        }
        return false;
    }

    public final WorkingCopyInfo hWorkingCopyInfo() {
        WorkingCopyInfo info = this.hElementManager().peekAtWorkingCopyInfo(this);
        if (info == null) {
            return null;
        }
        if (info.created) {
            return info;
        }
        if (this.equals(CURRENTLY_RECONCILED.get())) {
            return info;
        }
        return null;
    }

    @Override
    public final boolean hIsWorkingCopy() {
        return this.hWorkingCopyInfo() != null;
    }

    @Override
    public final boolean hNeedsReconciling() {
        WorkingCopyInfo info = this.hAcquireExistingWorkingCopy(null);
        if (info == null) {
            return false;
        }
        try {
            boolean bl = info.needsReconciling();
            return bl;
        }
        finally {
            this.hReleaseWorkingCopy();
        }
    }

    @Override
    public final void hReconcile(IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        try {
            WorkingCopyInfo info = this.hAcquireExistingWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (info == null) {
                return;
            }
            try {
                info.reconcile(context, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            }
            finally {
                this.hReleaseWorkingCopy();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected ReconcileOperation hReconcileOperation() {
        if (this.hModel().getModelContext().get(INotificationManager.class) != null) {
            return new NotifyingReconcileOperation();
        }
        return new ReconcileOperation();
    }

    protected IContext hWorkingCopyContext(IContext context) {
        return Contexts.EMPTY_CONTEXT;
    }

    protected void hWorkingCopyModeChanged() {
        INotificationManager notificationManager = this.hModel().getModelContext().get(INotificationManager.class);
        if (notificationManager == null) {
            return;
        }
        ElementDelta.Factory deltaFactory = this.hModel().getModelContext().get(ElementDelta.Factory.class);
        if (deltaFactory == null) {
            deltaFactory = element -> new ElementDelta(element);
        }
        ElementDelta rootDelta = deltaFactory.newDelta(this.hRoot());
        ElementDelta.Builder builder = new ElementDelta.Builder(rootDelta);
        if (this.hFileExists()) {
            builder.changed(this, 256L);
        } else if (this.hIsWorkingCopy()) {
            builder.added(this, 256L);
        } else {
            builder.removed(this, 256L);
        }
        notificationManager.fireElementChangeEvent(new ElementChangeEvent(1, builder.getDelta()));
    }

    @Override
    protected void hValidateExistence(IContext context) throws CoreException {
        if (!this.hIsWorkingCopy() && !this.hFileExists()) {
            throw this.hDoesNotExistException();
        }
    }

    @Override
    void hBuildStructure0(IContext context, IProgressMonitor monitor) throws CoreException {
        if (!context.containsKey(SOURCE_CONTENTS) && !context.containsKey(SOURCE_AST)) {
            NonExpiringSnapshot snapshot;
            if (this.hIsWorkingCopy()) {
                throw new AssertionError();
            }
            Throwable throwable = null;
            Object var5_5 = null;
            try (ISnapshotProvider provider = this.hFileSnapshotProvider();){
                try {
                    snapshot = new NonExpiringSnapshot(provider);
                }
                catch (IllegalStateException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CoreException) {
                        throw (CoreException)cause;
                    }
                    throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            context = Contexts.with(Contexts.of(SOURCE_CONTENTS, snapshot.getContents()), Contexts.of(SOURCE_SNAPSHOT, snapshot.getWrappedSnapshot()), context);
        }
        super.hBuildStructure0(context, monitor);
        Map newElements = (Map)context.get(NEW_ELEMENTS);
        Object body = newElements.get(this);
        if (body instanceof SourceElementBody) {
            ISnapshot snapshot;
            SourceElementBody thisBody = (SourceElementBody)body;
            String source = context.get(SOURCE_CONTENTS);
            if (source != null) {
                thisBody.setFullRange(new TextRange(0, source.length()));
            }
            if ((snapshot = context.get(SOURCE_SNAPSHOT)) != null) {
                SourceFile.setSnapshot(thisBody, snapshot, newElements);
            }
        }
    }

    protected abstract boolean hFileExists();

    protected abstract ISnapshotProvider hFileSnapshotProvider();

    protected abstract IBuffer hFileBuffer(IContext var1, IProgressMonitor var2) throws CoreException;

    @Override
    protected abstract void hBuildStructure(IContext var1, IProgressMonitor var2) throws CoreException;

    @Override
    protected void hGenerateAncestorBodies(IContext context, IProgressMonitor monitor) throws CoreException {
        if (this.hIsWorkingCopy()) {
            return;
        }
        super.hGenerateAncestorBodies(context, monitor);
    }

    @Override
    protected boolean hClose(boolean external) {
        if (this.hIsWorkingCopy()) {
            return false;
        }
        return super.hClose(external);
    }

    @Override
    protected void hToStringName(StringBuilder builder, IContext context) {
        if (this.hIsWorkingCopy()) {
            builder.append("[Working copy] ");
        }
        super.hToStringName(builder, context);
    }

    private static void setSnapshot(SourceElementBody body, ISnapshot snapshot, Map<IElement, Object> newElements) {
        body.setSnapshot(snapshot);
        ISourceConstruct[] iSourceConstructArray = body.getChildren();
        int n = iSourceConstructArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceConstruct child = iSourceConstructArray[n2];
            Object childBody = newElements.get(child);
            if (childBody instanceof SourceElementBody) {
                SourceFile.setSnapshot((SourceElementBody)childBody, snapshot, newElements);
            }
            ++n2;
        }
    }

    protected class NotifyingReconcileOperation
    extends ReconcileOperation {
        protected NotifyingReconcileOperation() {
        }

        @Override
        protected void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            ElementDelta.Factory deltaFactory = SourceFile.this.hModel().getModelContext().get(ElementDelta.Factory.class);
            if (deltaFactory == null) {
                deltaFactory = element -> new ElementDelta(element);
            }
            ElementDelta rootDelta = deltaFactory.newDelta(SourceFile.this);
            ElementDifferencer differ = new ElementDifferencer(new ElementDelta.Builder(rootDelta));
            this.doReconcile(context, monitor);
            differ.buildDelta();
            if (!differ.isEmptyDelta()) {
                SourceFile.this.hModel().getModelContext().get(INotificationManager.class).fireElementChangeEvent(new ElementChangeEvent(2, differ.getDelta()));
            }
        }

        protected void doReconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            super.reconcile(context, monitor);
        }
    }

    protected class ReconcileOperation {
        protected ReconcileOperation() {
        }

        protected void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            boolean create;
            if (context.get(SOURCE_AST) == null && context.get(SOURCE_CONTENTS) == null) {
                throw new IllegalArgumentException();
            }
            WorkingCopyInfo info = SourceFile.this.hElementManager().peekAtWorkingCopyInfo(SourceFile.this);
            boolean bl = create = !info.created;
            if (create || !context.getOrDefault(RECONCILING_FORCED).booleanValue() || context.getOrDefault(REBUILD_STRUCTURE_IF_FORCED).booleanValue()) {
                if (CURRENTLY_RECONCILED.get() != null) {
                    throw new AssertionError();
                }
                CURRENTLY_RECONCILED.set(SourceFile.this);
                try {
                    SourceFile.this.hOpen(Contexts.with(Contexts.of(FORCE_OPEN, Boolean.valueOf(true)), context), monitor);
                }
                finally {
                    CURRENTLY_RECONCILED.set(null);
                }
            }
            if (create) {
                if (!info.created) {
                    throw new AssertionError();
                }
                SourceFile.this.hWorkingCopyModeChanged();
            }
        }
    }

    private abstract class WorkingCopyProvider {
        private WorkingCopyProvider() {
        }

        public WorkingCopyInfo acquireWorkingCopy() {
            WorkingCopyInfo info;
            boolean success;
            do {
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                info = this.doAcquireWorkingCopy();
                if (info == null) {
                    return null;
                }
                success = false;
                try {
                    success = this.waitForInit(info);
                }
                finally {
                    if (!success) {
                        SourceFile.this.hReleaseWorkingCopy();
                    }
                }
            } while (!success);
            return info;
        }

        protected abstract WorkingCopyInfo doAcquireWorkingCopy();

        protected boolean isCanceled() {
            return false;
        }

        private boolean waitForInit(WorkingCopyInfo info) {
            int i = 0;
            while (i < 10) {
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    return info.initTask.wasSuccessful(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                ++i;
            }
            return false;
        }
    }
}

