/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.SourceConstruct;
import org.eclipse.handly.util.ToStringOptions;

public class StructureHelper {
    private final Map<IElement, Object> newElements;
    private final Map<Body, List<IElement>> children = new HashMap<Body, List<IElement>>();

    public StructureHelper(Map<IElement, Object> newElements) {
        if (newElements == null) {
            throw new IllegalArgumentException();
        }
        this.newElements = newElements;
    }

    public void addChild(Body parentBody, IElement child, Object childBody) {
        List<IElement> childrenList;
        if (parentBody == null) {
            throw new IllegalArgumentException();
        }
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (childBody != null) {
            this.resolveDuplicates(child);
            if (this.newElements.containsKey(child)) {
                throw new AssertionError((Object)("Attempt to add an already present element: " + Elements.toString(child, Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM))));
            }
            this.newElements.put(child, childBody);
        }
        if ((childrenList = this.children.get(parentBody)) == null) {
            childrenList = new ArrayList<IElement>();
            this.children.put(parentBody, childrenList);
        }
        childrenList.add(child);
    }

    public void complete(Body body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        List<IElement> childrenList = this.children.remove(body);
        body.setChildren(childrenList == null ? Body.NO_CHILDREN : childrenList.toArray(Body.NO_CHILDREN));
    }

    protected void resolveDuplicates(IElement element) {
        if (!(element instanceof SourceConstruct)) {
            return;
        }
        SourceConstruct sc = (SourceConstruct)element;
        while (this.newElements.containsKey(sc)) {
            sc.hIncrementOccurrenceCount();
        }
    }
}

