/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.Property;

public abstract class WorkingCopyInfo {
    private final SourceFile sourceFile;
    private final IBuffer buffer;
    private IContext context = Contexts.EMPTY_CONTEXT;
    final InitTask initTask = new InitTask();
    volatile boolean created;
    int refCount;
    protected static final Property<Object> SOURCE_AST = SourceFile.SOURCE_AST;
    protected static final Property<String> SOURCE_CONTENTS = SourceFile.SOURCE_CONTENTS;
    protected static final Property<ISnapshot> SOURCE_SNAPSHOT = SourceFile.SOURCE_SNAPSHOT;
    protected static final Property<Boolean> RECONCILING_FORCED = SourceFile.RECONCILING_FORCED;

    public WorkingCopyInfo(SourceFile sourceFile, IBuffer buffer) {
        this.sourceFile = sourceFile;
        if (this.sourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        if (this.buffer == null) {
            throw new IllegalArgumentException();
        }
    }

    public final SourceFile getSourceFile() {
        return this.sourceFile;
    }

    public final IBuffer getBuffer() {
        return this.buffer;
    }

    public IContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        WorkingCopyInfo workingCopyInfo = this;
        synchronized (workingCopyInfo) {
            if (this.refCount > 0) {
                throw new IllegalStateException();
            }
            if (this.refCount < 0) {
                return;
            }
            this.refCount = -1;
        }
        this.onDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDisposed() {
        WorkingCopyInfo workingCopyInfo = this;
        synchronized (workingCopyInfo) {
            return this.refCount < 0;
        }
    }

    protected void onInit() throws CoreException {
    }

    protected void onDispose() {
    }

    protected abstract boolean needsReconciling();

    protected abstract void reconcile(IContext var1, IProgressMonitor var2) throws CoreException;

    protected final void reconcile0(IContext context, IProgressMonitor monitor) throws CoreException {
        this.sourceFile.hReconcileOperation().reconcile(context, monitor);
    }

    public final boolean isInitialized() {
        try {
            return this.initTask.wasSuccessful(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public static interface Factory {
        public WorkingCopyInfo newWorkingCopyInfo(SourceFile var1, IBuffer var2);
    }

    class InitTask {
        private IContext creationContext;
        private IProgressMonitor monitor;
        private final FutureTask<?> futureTask = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws CoreException {
                InitTask.this.run();
                return null;
            }
        });

        InitTask() {
        }

        void execute(IContext context, IProgressMonitor monitor) throws CoreException {
            this.creationContext = context;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.monitor = monitor;
            this.futureTask.run();
            this.monitor = null;
            this.creationContext = null;
            try {
                this.futureTask.get();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CoreException) {
                    throw (CoreException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new AssertionError((Object)cause);
            }
        }

        boolean wasSuccessful(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            try {
                this.futureTask.get(timeout, unit);
                return true;
            }
            catch (ExecutionException e) {
                return false;
            }
        }

        private void run() throws CoreException {
            WorkingCopyInfo.this.context = WorkingCopyInfo.this.sourceFile.hWorkingCopyContext(this.creationContext);
            WorkingCopyInfo.this.onInit();
            WorkingCopyInfo.this.reconcile(Contexts.of(Elements.FORCE_RECONCILING, Boolean.valueOf(true)), this.monitor);
            if (!WorkingCopyInfo.this.created) {
                throw new AssertionError((Object)"Working copy creation was not completed. Ill-behaved implementation of #reconcile?");
            }
        }
    }
}

