/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.ICoreTextFileBufferProvider;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.TextFileSnapshot;

public abstract class WorkspaceSourceFile
extends SourceFile {
    private final IFile file;

    public WorkspaceSourceFile(Element parent, IFile file) {
        super(parent, file.getName());
        this.file = file;
    }

    @Override
    public final IResource hResource() {
        return this.file;
    }

    @Override
    public final IFile hFile() {
        return this.file;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WorkspaceSourceFile)) {
            return false;
        }
        return this.file.equals((Object)((WorkspaceSourceFile)o).file) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    protected boolean hFileExists() {
        return this.file.exists();
    }

    @Override
    protected final IBuffer hFileBuffer(IContext context, IProgressMonitor monitor) throws CoreException {
        ICoreTextFileBufferProvider provider = ICoreTextFileBufferProvider.forLocation(this.file.getFullPath(), LocationKind.IFILE, ITextFileBufferManager.DEFAULT);
        if (!context.getOrDefault(Elements.CREATE_BUFFER).booleanValue() && provider.getBuffer() == null) {
            return null;
        }
        return new TextFileBuffer(provider, monitor);
    }

    @Override
    protected final ISnapshotProvider hFileSnapshotProvider() {
        return () -> {
            TextFileSnapshot result = new TextFileSnapshot(this.file, TextFileSnapshot.Layer.FILESYSTEM);
            if (!result.exists()) {
                throw new IllegalStateException(this.hDoesNotExistException());
            }
            if (result.getContents() == null && !result.getStatus().isOK()) {
                throw new IllegalStateException(new CoreException(result.getStatus()));
            }
            return result;
        };
    }
}

