/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui;

import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.internal.examples.basic.ui.model.ExternalFooProject;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.ui.IEditorInput;

@Singleton
public class FooInputElementProvider
implements IInputElementProvider {
    private Map<IFooFile, IEditorInput> fakeFooFiles = new WeakHashMap<IFooFile, IEditorInput>();

    public IElement getElement(IEditorInput input) {
        if (input == null) {
            return null;
        }
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file != null) {
            return FooModelCore.create(file);
        }
        return this.getFakeFooFile(input);
    }

    private synchronized IFooFile getFakeFooFile(IEditorInput input) {
        Set<Map.Entry<IFooFile, IEditorInput>> entrySet = this.fakeFooFiles.entrySet();
        for (Map.Entry<IFooFile, IEditorInput> entry : entrySet) {
            if (!entry.getValue().equals(input)) continue;
            return entry.getKey();
        }
        IFooFile created = FooInputElementProvider.createFakeFooFile(input);
        if (created != null) {
            this.fakeFooFiles.put(created, input);
        }
        return created;
    }

    private static IFooFile createFakeFooFile(IEditorInput input) {
        ExternalFooProject project = new ExternalFooProject();
        return project.getFooFile(input.getName());
    }
}

