/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.examples.javamodel;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;

public class JavaModelCore {
    public static IJavaModel getJavaModel() {
        return JavaModelManager.INSTANCE.getModel();
    }

    public static IJavaElement create(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource instanceof IProject) {
            return JavaModelCore.create((IProject)resource);
        }
        if (resource instanceof IFolder) {
            return JavaModelCore.create((IFolder)resource);
        }
        if (resource instanceof IFile) {
            return JavaModelCore.create((IFile)resource);
        }
        return JavaModelCore.getJavaModel();
    }

    public static IJavaProject create(IProject project) {
        if (project == null) {
            return null;
        }
        return JavaModelCore.getJavaModel().getJavaProject(project.getName());
    }

    public static IJavaElement create(IFolder folder) {
        if (folder == null) {
            return null;
        }
        IJavaProject javaProject = JavaModelCore.create(folder.getProject());
        IPackageFragment pkg = javaProject.findPackageFragment((IResource)folder);
        if (pkg != null && pkg.isDefaultPackage()) {
            return pkg.getParent();
        }
        return pkg;
    }

    public static IJavaElement create(IFile file) {
        if (file == null) {
            return null;
        }
        if ("java".equals(file.getFileExtension())) {
            return JavaModelCore.createCompilationUnitFrom(file);
        }
        return null;
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file) {
        if (file == null) {
            return null;
        }
        IContainer parent = file.getParent();
        if (!(parent instanceof IFolder)) {
            return null;
        }
        IJavaElement element = JavaModelCore.create((IFolder)parent);
        if (element == null) {
            return null;
        }
        IPackageFragment pkg = element instanceof IPackageFragment ? (IPackageFragment)element : ((IPackageFragmentRoot)element).getPackageFragment("");
        return pkg.getCompilationUnit(file.getName());
    }

    private JavaModelCore() {
    }
}

