/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.model.impl.NotificationManager;
import org.eclipse.handly.model.impl.SimpleElement;
import org.eclipse.handly.model.impl.SimpleModel;

public class NotificationManagerTest
extends TestCase {
    private static final ElementDelta NULL_DELTA = new ElementDelta((IElement)new SimpleElement(null, null, new SimpleModel()));
    private static final IElementChangeEvent POST_CHANGE = new ElementChangeEvent(1, (IElementDelta)NULL_DELTA);
    private static final IElementChangeEvent POST_RECONCILE = new ElementChangeEvent(2, (IElementDelta)NULL_DELTA);
    private NotificationManager manager;
    private Listener listener;

    protected void setUp() throws Exception {
        this.manager = new NotificationManager();
        this.listener = new Listener();
    }

    public void test1() {
        this.manager.addElementChangeListener((IElementChangeListener)this.listener);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertSame((Object)POST_CHANGE, (Object)this.listener.event);
        this.manager.fireElementChangeEvent(POST_RECONCILE);
        NotificationManagerTest.assertSame((Object)POST_RECONCILE, (Object)this.listener.event);
        this.listener.event = null;
        this.manager.removeElementChangeListener((IElementChangeListener)this.listener);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertNull((Object)this.listener.event);
        this.manager.fireElementChangeEvent(POST_RECONCILE);
        NotificationManagerTest.assertNull((Object)this.listener.event);
    }

    public void test2() {
        this.manager.addElementChangeListener((IElementChangeListener)this.listener);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertSame((Object)POST_CHANGE, (Object)this.listener.event);
        this.manager.fireElementChangeEvent(POST_RECONCILE);
        NotificationManagerTest.assertSame((Object)POST_RECONCILE, (Object)this.listener.event);
        this.manager.addElementChangeListener((IElementChangeListener)this.listener, 1);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertSame((Object)POST_CHANGE, (Object)this.listener.event);
        this.manager.fireElementChangeEvent(POST_RECONCILE);
        NotificationManagerTest.assertSame((Object)POST_CHANGE, (Object)this.listener.event);
        this.manager.addElementChangeListener((IElementChangeListener)this.listener, 2);
        this.manager.fireElementChangeEvent(POST_RECONCILE);
        NotificationManagerTest.assertSame((Object)POST_RECONCILE, (Object)this.listener.event);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertSame((Object)POST_RECONCILE, (Object)this.listener.event);
        this.listener.event = null;
        this.manager.addElementChangeListener((IElementChangeListener)this.listener, 0);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertNull((Object)this.listener.event);
        this.manager.fireElementChangeEvent(POST_RECONCILE);
        NotificationManagerTest.assertNull((Object)this.listener.event);
    }

    public void test3() {
        ArrayList events = new ArrayList();
        IElementChangeListener listener = event -> {
            boolean bl = events.add(event);
        };
        this.manager.addElementChangeListener(listener);
        this.manager.addElementChangeListener(listener);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertEquals((int)1, (int)events.size());
        events.clear();
        this.manager.removeElementChangeListener(listener);
        this.manager.fireElementChangeEvent(POST_CHANGE);
        NotificationManagerTest.assertTrue((boolean)events.isEmpty());
        this.manager.removeElementChangeListener(listener);
    }

    private static class Listener
    implements IElementChangeListener {
        public IElementChangeEvent event;

        private Listener() {
        }

        public void elementChanged(IElementChangeEvent event) {
            this.event = event;
        }
    }
}

