/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.navigator.Messages;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;

public class OpenAction
extends BaseSelectionListenerAction {
    protected final IWorkbenchPage page;
    protected final EditorUtility editorUtility;

    public OpenAction(IWorkbenchPage page, EditorUtility editorUtility) {
        super(Messages.OpenAction_text);
        if (page == null) {
            throw new IllegalArgumentException();
        }
        if (editorUtility == null) {
            throw new IllegalArgumentException();
        }
        this.page = page;
        this.editorUtility = editorUtility;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null) {
            return;
        }
        for (Object element : selection) {
            IEditorReference reference = this.editorUtility.findEditor(this.page, element);
            if (reference != null) {
                IEditorPart editor = reference.getEditor(true);
                if (editor == null) continue;
                if (OpenStrategy.activateOnOpen()) {
                    this.page.activate((IWorkbenchPart)editor);
                } else {
                    this.page.bringToTop((IWorkbenchPart)editor);
                }
                this.editorUtility.revealElement(editor, element);
                continue;
            }
            IEditorInput input = this.editorUtility.getEditorInput(element);
            if (input == null) continue;
            try {
                IFile file = ResourceUtil.getFile((IEditorInput)input);
                IEditorDescriptor descriptor = file != null ? IDE.getEditorDescriptor((IFile)file) : IDE.getEditorDescriptor((String)input.getName());
                IEditorPart editor = this.page.openEditor(input, descriptor.getId(), OpenStrategy.activateOnOpen());
                if (editor == null) continue;
                this.editorUtility.revealElement(editor, element);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (this.editorUtility.getEditorInput(element) != null) continue;
            return false;
        }
        return true;
    }
}

