/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;

public abstract class OutlineLinkingHelper
extends OpenAndLinkWithEditorHelper {
    private ICommonOutlinePage outlinePage;
    private boolean isLinkingEnabled;
    private ISelectionChangedListener editorListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (OutlineLinkingHelper.this.isLinkingEnabled && !OutlineLinkingHelper.this.outlinePage.getControl().isFocusControl()) {
                OutlineLinkingHelper.this.linkToOutline(event.getSelection());
            }
        }
    };

    public OutlineLinkingHelper(ICommonOutlinePage outlinePage) {
        super((StructuredViewer)outlinePage.getTreeViewer());
        this.outlinePage = outlinePage;
        ISelectionProvider selectionProvider = outlinePage.getEditor().getSite().getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.editorListener);
        } else {
            selectionProvider.addSelectionChangedListener(this.editorListener);
        }
    }

    public final ICommonOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.outlinePage.getEditor().getSite().getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.editorListener);
        } else {
            selectionProvider.removeSelectionChangedListener(this.editorListener);
        }
        super.dispose();
    }

    public void setLinkWithEditor(boolean enabled) {
        super.setLinkWithEditor(enabled);
        this.isLinkingEnabled = enabled;
        if (enabled) {
            this.linkToOutline(this.outlinePage.getEditor().getSite().getSelectionProvider().getSelection());
        }
    }

    protected void activate(ISelection selection) {
        this.linkToEditor(selection);
    }

    protected void open(ISelection selection, boolean activate) {
        this.linkToEditor(selection);
    }

    protected abstract void linkToOutline(ISelection var1);
}

