/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.ui.texteditor.TextEditorBuffer;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.handly.xtext.ui.editor.XtextWorkingCopyInfo;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

@Singleton
public class HandlyXtextEditorCallback
extends IXtextEditorCallback.NullImpl {
    private IInputElementProvider inputElementProvider;
    private Map<IEditorInput, WorkingCopyEditorInfo> workingCopyEditors = new HashMap<IEditorInput, WorkingCopyEditorInfo>();
    private Map<MultiPageEditorPart, Set<XtextEditor>> nestedEditors = new HashMap<MultiPageEditorPart, Set<XtextEditor>>();
    private Map<XtextEditor, EditorInfo> editorInfoMap = new HashMap<XtextEditor, EditorInfo>();

    @Inject
    public void setInputElementProvider(IInputElementProvider provider) {
        this.inputElementProvider = provider;
    }

    public void afterCreatePartControl(XtextEditor editor) {
        this.connect(editor);
        this.registerContainer(editor);
    }

    public void beforeDispose(XtextEditor editor) {
        this.disconnectWorkingCopy(editor);
        this.deregisterContainer(editor);
        this.disconnect(editor);
    }

    public void beforeSetInput(XtextEditor editor) {
        this.disconnectWorkingCopy(editor);
    }

    public void afterSetInput(XtextEditor editor) {
        if (this.isActive(editor)) {
            this.connectWorkingCopy(editor);
        }
    }

    protected void afterSelectionChange(XtextEditor editor, ISelection selection) {
        if (selection != null) {
            this.setHighlightRange(editor, selection);
        }
    }

    protected void setHighlightRange(XtextEditor editor, ISelection selection) {
        this.scheduleHighlightRangeJob(editor, selection);
    }

    protected ISourceFile getSourceFile(XtextEditor editor) {
        IElement inputElement = this.inputElementProvider.getElement(editor.getEditorInput());
        if (!(inputElement instanceof ISourceFile)) {
            return null;
        }
        return (ISourceFile)inputElement;
    }

    protected final ISourceFile getWorkingCopy(XtextEditor editor) {
        WorkingCopyEditorInfo info = this.workingCopyEditors.get(editor.getEditorInput());
        if (info == null || info.editor != editor) {
            return null;
        }
        return info.workingCopy;
    }

    protected ISourceFile acquireWorkingCopy(XtextEditor editor) throws CoreException {
        ISourceFile sourceFile = this.getSourceFile(editor);
        if (sourceFile instanceof SourceFile) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TextEditorBuffer buffer = new TextEditorBuffer((ITextEditor)editor);){
                ((SourceFile)sourceFile).hBecomeWorkingCopy(Contexts.with((IContext[])new IContext[]{Contexts.of((Property)SourceFile.WORKING_COPY_BUFFER, (Object)buffer), Contexts.of((Property)SourceFile.WORKING_COPY_INFO_FACTORY, (sf, b) -> new XtextWorkingCopyInfo(sf, b))}), null);
                return sourceFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    protected void releaseWorkingCopy(XtextEditor editor, ISourceFile workingCopy) {
        ((SourceFile)workingCopy).hReleaseWorkingCopy();
    }

    private boolean isActive(XtextEditor editor) {
        IEditorSite site = editor.getEditorSite();
        if (site == null) {
            return false;
        }
        IEditorPart activeEditor = site.getPage().getActiveEditor();
        return editor == activeEditor || activeEditor != null && this.getContainer(editor) == activeEditor;
    }

    private MultiPageEditorPart getContainer(XtextEditor editor) {
        MultiPageEditorPart container = null;
        IEditorSite site = editor.getEditorSite();
        while (site instanceof MultiPageEditorSite) {
            container = ((MultiPageEditorSite)site).getMultiPageEditor();
            site = container.getEditorSite();
        }
        return container;
    }

    private void registerContainer(XtextEditor editor) {
        MultiPageEditorPart container = this.getContainer(editor);
        if (container == null) {
            return;
        }
        Set<XtextEditor> nestedSet = this.nestedEditors.get(container);
        if (nestedSet == null) {
            nestedSet = new HashSet<XtextEditor>();
            this.nestedEditors.put(container, nestedSet);
        }
        nestedSet.add(editor);
    }

    private void deregisterContainer(XtextEditor editor) {
        MultiPageEditorPart container = this.getContainer(editor);
        if (container == null) {
            return;
        }
        Set<XtextEditor> nestedSet = this.nestedEditors.get(container);
        if (nestedSet != null) {
            nestedSet.remove(editor);
            if (nestedSet.isEmpty()) {
                this.nestedEditors.remove(container);
            }
        }
    }

    private void connect(final XtextEditor editor) {
        IPartListener partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part == editor || part == HandlyXtextEditorCallback.this.getContainer(editor)) {
                    HandlyXtextEditorCallback.this.connectWorkingCopy(editor);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                this.partActivated(part);
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }
        };
        editor.getSite().getWorkbenchWindow().getPartService().addPartListener(partListener);
        ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HandlyXtextEditorCallback.this.afterSelectionChange(editor, event.getSelection());
            }
        };
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(selectionChangedListener);
        } else {
            selectionProvider.addSelectionChangedListener(selectionChangedListener);
        }
        EditorInfo info = new EditorInfo();
        info.partListener = partListener;
        info.selectionChangedListener = selectionChangedListener;
        info.highlightRangeJob = new HighlightRangeJob(editor);
        this.editorInfoMap.put(editor, info);
    }

    private void disconnect(XtextEditor editor) {
        EditorInfo info = this.editorInfoMap.remove(editor);
        if (info == null) {
            return;
        }
        editor.getSite().getWorkbenchWindow().getPartService().removePartListener(info.partListener);
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(info.selectionChangedListener);
        } else {
            selectionProvider.removeSelectionChangedListener(info.selectionChangedListener);
        }
        HighlightRangeJob highlightRangeJob = info.highlightRangeJob;
        highlightRangeJob.cancel();
        highlightRangeJob.setArgs(null);
    }

    private void connectWorkingCopy(XtextEditor editor) {
        XtextEditor workingCopyEditor = this.getWorkingCopyEditor(editor.getEditorInput());
        if (editor != workingCopyEditor) {
            if (workingCopyEditor != null) {
                this.disconnectWorkingCopy0(workingCopyEditor);
            }
            this.connectWorkingCopy0(editor);
        }
    }

    private void disconnectWorkingCopy(XtextEditor editor) {
        if (!this.disconnectWorkingCopy0(editor)) {
            return;
        }
        XtextEditor mruClone = this.findMruClone(editor);
        if (mruClone != null) {
            this.connectWorkingCopy0(mruClone);
        }
    }

    private void connectWorkingCopy0(XtextEditor editor) {
        ISourceFile workingCopy;
        block18: {
            workingCopy = null;
            try {
                workingCopy = this.acquireWorkingCopy(editor);
            }
            catch (CoreException e) {
                if (!editor.getEditorInput().exists()) break block18;
                Activator.log(e.getStatus());
            }
        }
        if (workingCopy != null) {
            if (!Elements.isWorkingCopy((ISourceFile)workingCopy)) {
                throw new AssertionError();
            }
            try {
                Throwable e = null;
                Object var4_7 = null;
                try (IBuffer buffer = Elements.getBuffer((ISourceFile)workingCopy);){
                    if (buffer.getDocument() != editor.getDocumentProvider().getDocument((Object)editor.getEditorInput())) {
                        this.releaseWorkingCopy(editor, workingCopy);
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        }
        this.workingCopyEditors.put(editor.getEditorInput(), new WorkingCopyEditorInfo(editor, workingCopy));
        if (workingCopy != null) {
            this.setHighlightRange(editor, editor.getSelectionProvider().getSelection());
        } else {
            editor.resetHighlightRange();
        }
    }

    private boolean disconnectWorkingCopy0(XtextEditor editor) {
        WorkingCopyEditorInfo info = this.workingCopyEditors.get(editor.getEditorInput());
        if (info == null || info.editor != editor) {
            return false;
        }
        this.workingCopyEditors.remove(editor.getEditorInput());
        if (info.workingCopy != null) {
            this.releaseWorkingCopy(editor, info.workingCopy);
            editor.resetHighlightRange();
        }
        return true;
    }

    private XtextEditor getWorkingCopyEditor(IEditorInput editorInput) {
        WorkingCopyEditorInfo info = this.workingCopyEditors.get(editorInput);
        if (info == null) {
            return null;
        }
        return info.editor;
    }

    private XtextEditor findMruClone(XtextEditor editor) {
        IEditorReference[] references;
        IEditorInput editorInput = editor.getEditorInput();
        IEditorReference[] iEditorReferenceArray = references = editor.getSite().getPage().findEditors(editorInput, null, 1);
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            Set<XtextEditor> nestedSet;
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart candidate = reference.getEditor(false);
            if (candidate instanceof XtextEditor) {
                if (candidate != editor) {
                    return (XtextEditor)candidate;
                }
            } else if (candidate instanceof MultiPageEditorPart && (nestedSet = this.nestedEditors.get(candidate)) != null) {
                for (XtextEditor nested : nestedSet) {
                    if (nested == editor || !editorInput.equals(nested.getEditorInput())) continue;
                    return nested;
                }
            }
            ++n2;
        }
        return null;
    }

    private void scheduleHighlightRangeJob(XtextEditor editor, ISelection selection) {
        ISourceFile workingCopy = this.getWorkingCopy(editor);
        if (workingCopy == null) {
            return;
        }
        EditorInfo info = this.editorInfoMap.get(editor);
        if (info == null) {
            return;
        }
        HighlightRangeJob highlightRangeJob = info.highlightRangeJob;
        highlightRangeJob.cancel();
        highlightRangeJob.setArgs(new HighlightArgs(workingCopy, selection));
        highlightRangeJob.schedule();
    }

    private static class EditorInfo {
        IPartListener partListener;
        ISelectionChangedListener selectionChangedListener;
        HighlightRangeJob highlightRangeJob;

        private EditorInfo() {
        }
    }

    private static class HighlightArgs {
        final ISourceFile sourceFile;
        final ISelection selection;

        HighlightArgs(ISourceFile sourceFile, ISelection selection) {
            this.sourceFile = sourceFile;
            this.selection = selection;
        }
    }

    private class HighlightRangeJob
    extends Job {
        private final XtextEditor editor;
        private volatile HighlightArgs args;

        HighlightRangeJob(XtextEditor editor) {
            super("");
            this.setSystem(true);
            this.editor = editor;
        }

        void setArgs(HighlightArgs args) {
            this.args = args;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int position;
            HighlightArgs args = this.args;
            if (args == null) {
                return Status.OK_STATUS;
            }
            ISourceFile sourceFile = args.sourceFile;
            ISelection selection = args.selection;
            ISourceElement selectedElement = null;
            if (selection instanceof ITextSelection && (position = ((ITextSelection)selection).getOffset()) >= 0) {
                try {
                    Elements.reconcile((ISourceFile)sourceFile, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.resetEditorHighlightRange(args);
                    return e.getStatus();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    selectedElement = Elements.getSourceElementAt((ISourceElement)sourceFile, (int)position, null);
                    if (sourceFile.equals((Object)selectedElement)) {
                        selectedElement = null;
                    }
                }
                catch (CoreException e) {
                    selectedElement = null;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (selectedElement == null || !Elements.exists(selectedElement)) {
                this.resetEditorHighlightRange(args);
            } else {
                TextRange r;
                try {
                    r = Elements.getSourceElementInfo(selectedElement).getFullRange();
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.resetEditorHighlightRange(args);
                    return e.getStatus();
                }
                if (r != null) {
                    this.setEditorHighlightRange(args, r.getOffset(), r.getLength());
                }
            }
            return Status.OK_STATUS;
        }

        private void setEditorHighlightRange(final HighlightArgs args, final int offset, final int length) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HighlightRangeJob.this.hasWorldChanged(args)) {
                        HighlightRangeJob.this.editor.setHighlightRange(offset, length, false);
                    }
                }
            });
        }

        private void resetEditorHighlightRange(final HighlightArgs args) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HighlightRangeJob.this.hasWorldChanged(args)) {
                        HighlightRangeJob.this.editor.resetHighlightRange();
                    }
                }
            });
        }

        private boolean hasWorldChanged(HighlightArgs baseArgs) {
            return baseArgs != this.args || !baseArgs.sourceFile.equals((Object)HandlyXtextEditorCallback.this.getWorkingCopy(this.editor)) || !baseArgs.selection.equals(this.editor.getSelectionProvider().getSelection());
        }
    }

    private static class WorkingCopyEditorInfo {
        final XtextEditor editor;
        final ISourceFile workingCopy;

        WorkingCopyEditorInfo(XtextEditor editor, ISourceFile workingCopy) {
            this.editor = editor;
            this.workingCopy = workingCopy;
        }
    }
}

