/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Context;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.handly.xtext.ui.editor.NoXtextResourceException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.resource.XtextResource;

public class XtextWorkingCopyInfo
extends WorkingCopyInfo {
    private final HandlyXtextDocument.IReconcilingListener reconcilingListener = new HandlyXtextDocument.IReconcilingListener(){

        @Override
        public void reconciled(XtextResource resource, NonExpiringSnapshot snapshot, boolean forced, IProgressMonitor monitor) throws Exception {
            Context context = new Context();
            context.bind(SOURCE_AST).to((Object)resource);
            context.bind(SOURCE_CONTENTS).to((Object)snapshot.getContents());
            context.bind(SOURCE_SNAPSHOT).to((Object)snapshot.getWrappedSnapshot());
            context.bind(RECONCILING_FORCED).to((Object)forced);
            XtextWorkingCopyInfo.this.reconcile0((IContext)context, monitor);
        }
    };

    public XtextWorkingCopyInfo(SourceFile sourceFile, IBuffer buffer) {
        super(sourceFile, buffer);
        IDocument document = buffer.getDocument();
        if (!(document instanceof HandlyXtextDocument)) {
            throw new IllegalArgumentException();
        }
    }

    protected void onInit() throws CoreException {
        super.onInit();
        this.getDocument().addReconcilingListener(this.reconcilingListener);
    }

    protected void onDispose() {
        this.getDocument().removeReconcilingListener(this.reconcilingListener);
        super.onDispose();
    }

    protected final boolean needsReconciling() {
        return this.getDocument().needsReconciling();
    }

    protected final void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
        try {
            this.getDocument().reconcile((Boolean)context.getOrDefault(Elements.FORCE_RECONCILING), monitor);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (NoXtextResourceException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    protected final HandlyXtextDocument getDocument() {
        return (HandlyXtextDocument)this.getBuffer().getDocument();
    }
}

