/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model;

import java.net.URI;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.IElementImpl;
import org.eclipse.handly.model.impl.ISourceElementImpl;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;

public class Elements {
    public static final ISourceElementInfo NO_SOURCE_ELEMENT_INFO = new NoSourceElementInfo();
    public static final Property<Boolean> FORCE_RECONCILING = Property.get(String.valueOf(Elements.class.getName()) + ".forceReconciling", Boolean.class).withDefault(false);
    public static final Property<Boolean> CREATE_BUFFER = Property.get(String.valueOf(Elements.class.getName()) + ".createBuffer", Boolean.class).withDefault(true);

    public static String getName(IElement element) {
        return ((IElementImpl)element).hName();
    }

    public static IElement getParent(IElement element) {
        return ((IElementImpl)element).hParent();
    }

    public static IElement getRoot(IElement element) {
        return ((IElementImpl)element).hRoot();
    }

    public static <T> T getAncestor(IElement element, Class<T> ancestorType) {
        return ((IElementImpl)element).hAncestor(ancestorType);
    }

    public static IModel getModel(IElement element) {
        return ((IElementImpl)element).hModel();
    }

    public static IResource getResource(IElement element) {
        return ((IElementImpl)element).hResource();
    }

    public static URI getLocationURI(IElement element) {
        return ((IElementImpl)element).hLocationURI();
    }

    public static boolean exists(IElement element) {
        return ((IElementImpl)element).hExists();
    }

    public static IElement[] getChildren(IElement element) throws CoreException {
        return ((IElementImpl)element).hChildren();
    }

    public static <T> T[] getChildren(IElement element, Class<T> childType) throws CoreException {
        return ((IElementImpl)element).hChildren(childType);
    }

    public static String toString(IElement element, IContext context) {
        return ((IElementImpl)element).hToString(context);
    }

    public static String toDisplayString(IElement element, IContext context) {
        return ((IElementImpl)element).hToDisplayString(context);
    }

    public static boolean equalsAndSameParent(IElement e1, IElement e2) {
        if (!e1.equals(e2)) {
            return false;
        }
        return Objects.equals(Elements.getParent(e1), Elements.getParent(e2));
    }

    public static ISourceElement getSourceElementAt(ISourceElement context, int position, ISnapshot base) throws CoreException {
        return ((ISourceElementImpl)context).hSourceElementAt(position, base);
    }

    public static ISourceElement getSourceElementAt2(ISourceElement context, int position, ISnapshot base) {
        try {
            return Elements.getSourceElementAt(context, position, base);
        }
        catch (CoreException e) {
            if (Elements.exists(context)) {
                Activator.log(e.getStatus());
            }
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        return null;
    }

    public static ISourceElementInfo getSourceElementInfo(ISourceElement element) throws CoreException {
        return ((ISourceElementImpl)element).hSourceElementInfo();
    }

    public static ISourceElementInfo getSourceElementInfo2(ISourceElement element) {
        try {
            return Elements.getSourceElementInfo(element);
        }
        catch (CoreException e) {
            if (Elements.exists(element)) {
                Activator.log(e.getStatus());
            }
            return NO_SOURCE_ELEMENT_INFO;
        }
    }

    public static ISourceFile getSourceFile(ISourceElement element) {
        if (element instanceof ISourceFile) {
            return (ISourceFile)element;
        }
        return Elements.getAncestor(element, ISourceFile.class);
    }

    public static boolean ensureReconciled(ISourceElement element, IProgressMonitor monitor) {
        ISourceFile sourceFile = Elements.getSourceFile(element);
        if (sourceFile != null) {
            try {
                Elements.reconcile(sourceFile, monitor);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                return false;
            }
        }
        return true;
    }

    public static IFile getFile(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).hFile();
    }

    public static boolean isWorkingCopy(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).hIsWorkingCopy();
    }

    public static boolean needsReconciling(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).hNeedsReconciling();
    }

    public static void reconcile(ISourceFile sourceFile, IProgressMonitor monitor) throws CoreException {
        Elements.reconcile(sourceFile, Contexts.EMPTY_CONTEXT, monitor);
    }

    public static void reconcile(ISourceFile sourceFile, IContext context, IProgressMonitor monitor) throws CoreException {
        ((ISourceFileImpl)sourceFile).hReconcile(context, monitor);
    }

    public static IBuffer getBuffer(ISourceFile sourceFile) throws CoreException {
        return Elements.getBuffer(sourceFile, Contexts.EMPTY_CONTEXT, null);
    }

    public static IBuffer getBuffer(ISourceFile sourceFile, IContext context, IProgressMonitor monitor) throws CoreException {
        return ((ISourceFileImpl)sourceFile).hBuffer(context, monitor);
    }

    private Elements() {
    }

    private static class NoSourceElementInfo
    implements ISourceElementInfo {
        static final ISourceConstruct[] NO_CHILDREN = new ISourceConstruct[0];

        private NoSourceElementInfo() {
        }

        @Override
        public ISnapshot getSnapshot() {
            return null;
        }

        @Override
        public <T> T get(Property<T> property) {
            return null;
        }

        @Override
        public ISourceConstruct[] getChildren() {
            return NO_CHILDREN;
        }

        @Override
        public TextRange getFullRange() {
            return null;
        }

        @Override
        public TextRange getIdentifyingRange() {
            return null;
        }
    }
}

