/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.handly.model.impl.IElementImpl;
import org.eclipse.handly.model.impl.IModelManager;
import org.eclipse.handly.model.impl.Messages;
import org.eclipse.handly.util.IndentPolicy;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.ToStringOptions;

public abstract class Element
extends PlatformObject
implements IElementImpl,
IModelManager.Provider {
    private final Element parent;
    private final String name;
    protected static final Object NO_BODY = new Object();
    protected static final Property<Map<IElement, Object>> NEW_ELEMENTS = new Property<Map<IElement, Object>>(String.valueOf(Element.class.getName()) + ".newElements"){};
    static final Property<Boolean> FORCE_OPEN = Property.get(String.valueOf(Element.class.getName()) + ".forceOpen", Boolean.class).withDefault(false);

    public Element(Element parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Element)) {
            return false;
        }
        Element other = (Element)obj;
        if (!this.hElementType().equals(other.hElementType())) {
            return false;
        }
        if (!this.hModel().equals(other.hModel())) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return this.hToString(Contexts.EMPTY_CONTEXT);
    }

    @Override
    public final String hName() {
        return this.name;
    }

    @Override
    public final Element hParent() {
        return this.parent;
    }

    @Override
    public IModel hModel() {
        return this.hModelManager().getModel();
    }

    @Override
    public boolean hExists() {
        if (this.hFindBody() != null) {
            return true;
        }
        if (this.parent != null && !this.parent.hExists()) {
            return false;
        }
        try {
            this.hValidateExistence(Contexts.EMPTY_CONTEXT);
            return true;
        }
        catch (CoreException e) {
            return false;
        }
    }

    @Override
    public IElement[] hChildren() throws CoreException {
        return this.hChildren(this.hBody());
    }

    public Object hFindBody() {
        return this.hElementManager().get(this);
    }

    public Object hPeekAtBody() {
        return this.hElementManager().peek(this);
    }

    public final boolean hClose() {
        return this.hClose(true);
    }

    @Override
    public String hToString(IContext context) {
        StringBuilder builder = new StringBuilder();
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int indentLevel = context.getOrDefault(ToStringOptions.INDENT_LEVEL);
        ToStringOptions.FormatStyle style = context.getOrDefault(ToStringOptions.FORMAT_STYLE);
        if (style == ToStringOptions.FormatStyle.FULL || style == ToStringOptions.FormatStyle.LONG) {
            Object body = this.hPeekAtBody();
            indentPolicy.appendIndent(builder, indentLevel);
            this.hToStringBody(builder, body, context);
            if (style == ToStringOptions.FormatStyle.FULL) {
                this.hToStringAncestors(builder, context);
            }
            if (body != null && this.hChildren(body).length > 0) {
                indentPolicy.appendLine(builder);
                this.hToStringChildren(builder, body, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.LONG), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(indentLevel + 1)), context));
            }
        } else {
            indentPolicy.appendIndent(builder, indentLevel);
            this.hToStringBody(builder, NO_BODY, context);
            if (style == ToStringOptions.FormatStyle.MEDIUM) {
                this.hToStringAncestors(builder, context);
            }
        }
        return builder.toString();
    }

    protected void hToStringAncestors(StringBuilder builder, IContext context) {
        if (this.parent != null && this.parent.hParent() != null) {
            builder.append(" [in ");
            this.parent.hToStringBody(builder, NO_BODY, context);
            this.parent.hToStringAncestors(builder, context);
            builder.append(']');
        }
    }

    protected void hToStringChildren(StringBuilder builder, Object body, IContext context) {
        if (body == null) {
            return;
        }
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        IElement[] children = this.hChildren(body);
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                indentPolicy.appendLine(builder);
            }
            builder.append(Elements.toString(children[i], context));
            ++i;
        }
    }

    protected void hToStringBody(StringBuilder builder, Object body, IContext context) {
        this.hToStringName(builder, context);
        if (body == null) {
            builder.append(" (not open)");
        }
    }

    protected void hToStringName(StringBuilder builder, IContext context) {
        builder.append(this.name);
    }

    protected Object hElementType() {
        return this.getClass();
    }

    protected ElementManager hElementManager() {
        return this.hModelManager().getElementManager();
    }

    protected CoreException hDoesNotExistException() {
        return new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.Element_Does_not_exist__0, this.hToDisplayString(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.FULL))), null));
    }

    protected abstract void hValidateExistence(IContext var1) throws CoreException;

    protected abstract void hBuildStructure(IContext var1, IProgressMonitor var2) throws CoreException;

    protected final Object hBody() throws CoreException {
        return this.hBody(Contexts.EMPTY_CONTEXT, null);
    }

    protected final Object hBody(IContext context, IProgressMonitor monitor) throws CoreException {
        Object body = this.hFindBody();
        if (body != null) {
            return body;
        }
        return this.hOpen(context, monitor);
    }

    protected IElement[] hChildren(Object body) {
        return ((Body)body).getChildren();
    }

    final Object hOpen(IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ElementManager elementManager = this.hElementManager();
        boolean hadTemporaryCache = elementManager.hasTemporaryCache();
        try {
            Map<IElement, Object> newElements = elementManager.getTemporaryCache();
            this.hGenerateBodies(Contexts.with(Contexts.of(NEW_ELEMENTS, newElements), context), monitor);
            Object body = newElements.get(this);
            if (body == null) {
                throw this.hDoesNotExistException();
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!hadTemporaryCache) {
                if (context.getOrDefault(FORCE_OPEN).booleanValue()) {
                    elementManager.put(this, newElements);
                } else {
                    Object existingBody = elementManager.putIfAbsent(this, newElements);
                    if (existingBody != null) {
                        body = existingBody;
                    }
                }
            }
            Object object = body;
            return object;
        }
        finally {
            if (!hadTemporaryCache) {
                elementManager.resetTemporaryCache();
            }
        }
    }

    protected boolean hIsOpenable() {
        return true;
    }

    protected final Element hOpenableParent() {
        Element result = this.parent;
        while (result != null && !result.hIsOpenable()) {
            result = result.parent;
        }
        return result;
    }

    protected void hGenerateAncestorBodies(IContext context, IProgressMonitor monitor) throws CoreException {
        Element openableParent = this.hOpenableParent();
        if (openableParent != null && openableParent.hFindBody() == null) {
            openableParent.hGenerateBodies(context, monitor);
        }
    }

    protected final void hGenerateBodies(IContext context, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 2);
        try {
            this.hGenerateAncestorBodies(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.hIsOpenable()) {
                this.hValidateExistence(context);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.hBuildStructure0(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                Object body = context.get(NEW_ELEMENTS).get(this);
                if (body == null) {
                    throw new AssertionError((Object)MessageFormat.format("No body for {0}. Incorrect {1}#hBuildStructure implementation?", this.toString(), this.getClass().getSimpleName()));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    void hBuildStructure0(IContext context, IProgressMonitor monitor) throws CoreException {
        this.hBuildStructure(context, monitor);
    }

    protected boolean hClose(boolean external) {
        if (external && !this.hIsOpenable()) {
            return false;
        }
        this.hElementManager().remove(this);
        return true;
    }

    protected void hRemoving(Object body) {
    }
}

