/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.junit.WorkspaceTestCase;

public class FooFileTest
extends WorkspaceTestCase {
    private IFooFile fooFile;

    protected void setUp() throws Exception {
        super.setUp();
        IFooProject fooProject = FooModelCore.create((IProject)this.setUpProject("Test002"));
        this.fooFile = fooProject.getFooFile("test.foo");
    }

    public void testFooFile() throws Exception {
        FooFileTest.assertTrue((boolean)this.fooFile.exists());
        FooFileTest.assertEquals((int)5, (int)this.fooFile.getChildren().length);
        IFooVar[] vars = this.fooFile.getVars();
        FooFileTest.assertEquals((int)2, (int)vars.length);
        FooFileTest.assertEquals((Object)this.fooFile.getVar("x"), (Object)vars[0]);
        FooFileTest.assertEquals((Object)this.fooFile.getVar("y"), (Object)vars[1]);
        IFooDef[] defs = this.fooFile.getDefs();
        FooFileTest.assertEquals((int)3, (int)defs.length);
        FooFileTest.assertEquals((Object)this.fooFile.getDef("f", 0), (Object)defs[0]);
        FooFileTest.assertEquals((Object)this.fooFile.getDef("f", 1), (Object)defs[1]);
        FooFileTest.assertEquals((Object)this.fooFile.getDef("f", 2), (Object)defs[2]);
        FooFileTest.assertEquals((int)0, (int)defs[0].getParameterNames().length);
        String[] parameterNames = defs[1].getParameterNames();
        FooFileTest.assertEquals((int)1, (int)parameterNames.length);
        FooFileTest.assertEquals((String)"x", (String)parameterNames[0]);
        parameterNames = defs[2].getParameterNames();
        FooFileTest.assertEquals((int)2, (int)parameterNames.length);
        FooFileTest.assertEquals((String)"x", (String)parameterNames[0]);
        FooFileTest.assertEquals((String)"y", (String)parameterNames[1]);
    }
}

