/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.impl.ElementDelta;

public class FooModelNotificationTest
extends WorkspaceTestCase {
    private IFooModel fooModel = FooModelCore.getFooModel();
    private FooModelListener listener = new FooModelListener();

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpProject("Test001");
        this.fooModel.addElementChangeListener((IElementChangeListener)this.listener);
    }

    protected void tearDown() throws Exception {
        this.fooModel.removeElementChangeListener((IElementChangeListener)this.listener);
        super.tearDown();
    }

    public void testFooModelNotification() throws Exception {
        IFooProject fooProject1 = this.fooModel.getFooProject("Test001");
        IFooProject fooProject2 = this.fooModel.getFooProject("Test002");
        this.setUpProject("Test002");
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().added((IElement)fooProject2).getDelta(), this.listener.delta);
        IFooFile fooFile1 = fooProject1.getFooFile("test.foo");
        fooFile1.getFile().touch(null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().changed((IElement)fooFile1, 1L).getDelta(), this.listener.delta);
        fooFile1.getFile().copy((IPath)new Path("/Test002/test1.foo"), true, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().added((IElement)fooProject2.getFooFile("test1.foo")).getDelta(), this.listener.delta);
        fooFile1.getFile().delete(true, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().removed((IElement)fooFile1).getDelta(), this.listener.delta);
        IFooFile fooFile2 = fooProject2.getFooFile("test.foo");
        IFooFile movedFooFile2 = fooProject1.getFooFile("test1.foo");
        fooFile2.getFile().move((IPath)new Path("/Test001/test1.foo"), true, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().movedTo((IElement)movedFooFile2, (IElement)fooFile2).movedFrom((IElement)fooFile2, (IElement)movedFooFile2).getDelta(), this.listener.delta);
        IFolder aFolder = fooProject1.getProject().getFolder("a");
        aFolder.delete(true, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().changed((IElement)fooProject1, 1L).getDelta(), this.listener.delta);
        FooModelNotificationTest.assertNull((Object)this.listener.delta.hResourceDeltas());
        ElementDelta projectDelta = this.listener.delta.hDeltaFor((IElement)fooProject1);
        FooModelNotificationTest.assertEquals((int)1, (int)projectDelta.hResourceDeltas().length);
        IResourceDelta resourceDelta = projectDelta.hResourceDeltas()[0];
        FooModelNotificationTest.assertEquals((int)2, (int)resourceDelta.getKind());
        FooModelNotificationTest.assertEquals((Object)aFolder, (Object)resourceDelta.getResource());
        IFile bFile = fooProject1.getProject().getFile("b");
        bFile.touch(null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().changed((IElement)fooProject1, 1L).getDelta(), this.listener.delta);
        FooModelNotificationTest.assertNull((Object)this.listener.delta.hResourceDeltas());
        projectDelta = this.listener.delta.hDeltaFor((IElement)fooProject1);
        FooModelNotificationTest.assertEquals((int)1, (int)projectDelta.hResourceDeltas().length);
        resourceDelta = projectDelta.hResourceDeltas()[0];
        FooModelNotificationTest.assertEquals((int)4, (int)resourceDelta.getKind());
        FooModelNotificationTest.assertEquals((Object)bFile, (Object)resourceDelta.getResource());
        IProject simpleProject = this.setUpProject("SimpleProject");
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().changed((IElement)this.fooModel, 1L).getDelta(), this.listener.delta);
        FooModelNotificationTest.assertEquals((int)1, (int)this.listener.delta.hResourceDeltas().length);
        resourceDelta = this.listener.delta.hResourceDeltas()[0];
        FooModelNotificationTest.assertEquals((int)1, (int)resourceDelta.getKind());
        FooModelNotificationTest.assertEquals((Object)simpleProject, (Object)resourceDelta.getResource());
        fooProject2.getProject().close(null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().removed((IElement)fooProject2, 64L).getDelta(), this.listener.delta);
        fooProject2.getProject().open(null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().added((IElement)fooProject2, 64L).getDelta(), this.listener.delta);
        fooProject2.getProject().delete(true, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().removed((IElement)fooProject2).getDelta(), this.listener.delta);
        IProjectDescription description = fooProject1.getProject().getDescription();
        String[] oldNatures = description.getNatureIds();
        description.setNatureIds(new String[0]);
        fooProject1.getProject().setDescription(description, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().removed((IElement)fooProject1, 128L).getDelta(), this.listener.delta);
        description.setNatureIds(oldNatures);
        fooProject1.getProject().setDescription(description, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().added((IElement)fooProject1, 128L).getDelta(), this.listener.delta);
        IFooProject movedFooProject1 = this.fooModel.getFooProject("Test");
        fooProject1.getProject().move((IPath)new Path("Test"), true, null);
        FooModelNotificationTest.assertDelta(this.newDeltaBuilder().movedTo((IElement)movedFooProject1, (IElement)fooProject1).movedFrom((IElement)fooProject1, (IElement)movedFooProject1).getDelta(), this.listener.delta);
    }

    private ElementDelta.Builder newDeltaBuilder() {
        return new ElementDelta.Builder(new ElementDelta((IElement)this.fooModel));
    }

    private static void assertDelta(ElementDelta expected, ElementDelta actual) {
        if (expected == null) {
            FooModelNotificationTest.assertNull((Object)actual);
            return;
        }
        FooModelNotificationTest.assertNotNull((Object)actual);
        FooModelNotificationTest.assertEquals((Object)expected.hElement(), (Object)actual.hElement());
        FooModelNotificationTest.assertEquals((int)expected.hKind(), (int)actual.hKind());
        FooModelNotificationTest.assertEquals((long)expected.hFlags(), (long)actual.hFlags());
        FooModelNotificationTest.assertEquals((Object)expected.hMovedToElement(), (Object)actual.hMovedToElement());
        FooModelNotificationTest.assertEquals((Object)expected.hMovedFromElement(), (Object)actual.hMovedFromElement());
        ElementDelta[] expectedChildren = expected.hAffectedChildren();
        ElementDelta[] actualChildren = actual.hAffectedChildren();
        FooModelNotificationTest.assertEquals((int)expectedChildren.length, (int)actualChildren.length);
        int i = 0;
        while (i < expectedChildren.length) {
            FooModelNotificationTest.assertDelta(expectedChildren[i], actualChildren[i]);
            ++i;
        }
    }

    private static class FooModelListener
    implements IElementChangeListener {
        public ElementDelta delta;

        private FooModelListener() {
        }

        public void elementChanged(IElementChangeEvent event) {
            this.delta = (ElementDelta)event.getDelta();
        }
    }
}

