/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelManager;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.IFooElementInternal;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Element;

public class FooModel
extends Element
implements IFooModel,
IFooElementInternal,
IModel {
    private final IWorkspace workspace;

    public FooModel(IWorkspace workspace) {
        super(null, "");
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
    }

    public int getApiLevel() {
        return 0;
    }

    public IContext getModelContext() {
        return FooModelManager.INSTANCE.getModelContext();
    }

    @Override
    public void addElementChangeListener(IElementChangeListener listener) {
        FooModelManager.INSTANCE.getNotificationManager().addElementChangeListener(listener);
    }

    @Override
    public void removeElementChangeListener(IElementChangeListener listener) {
        FooModelManager.INSTANCE.getNotificationManager().removeElementChangeListener(listener);
    }

    @Override
    public IFooProject getFooProject(String name) {
        return new FooProject(this, this.workspace.getRoot().getProject(name));
    }

    @Override
    public IFooProject[] getFooProjects() throws CoreException {
        IElement[] children = this.getChildren();
        int length = children.length;
        IFooProject[] result = new IFooProject[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FooModel other = (FooModel)obj;
        return this.workspace.equals(other.workspace);
    }

    public int hashCode() {
        return this.workspace.hashCode();
    }

    public IResource hResource() {
        return this.workspace.getRoot();
    }

    public boolean hExists() {
        return true;
    }

    public void hValidateExistence(IContext context) {
    }

    public void hBuildStructure(IContext context, IProgressMonitor monitor) throws CoreException {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<FooProject> fooProjects = new ArrayList<FooProject>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature")) {
                fooProjects.add(new FooProject(this, project));
            }
            ++n2;
        }
        Body body = new Body();
        body.setChildren(fooProjects.toArray(Body.NO_CHILDREN));
        ((Map)context.get(NEW_ELEMENTS)).put(this, body);
    }

    public void hToStringName(StringBuilder builder, IContext context) {
        builder.append("FooModel");
    }
}

