/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel.ui.navigator;

import org.eclipse.handly.internal.examples.javamodel.ui.navigator.JavaNavigator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class WorkingSetActionProvider
extends CommonActionProvider {
    private WorkingSetFilterActionGroup workingSetActionGroup;
    private boolean contributedToViewMenu = false;

    public void init(ICommonActionExtensionSite actionSite) {
        super.init(actionSite);
        ICommonViewerWorkbenchSite viewSite = (ICommonViewerWorkbenchSite)actionSite.getViewSite();
        final JavaNavigator navigator = (JavaNavigator)viewSite.getPart();
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    Object newValue = event.getNewValue();
                    if (newValue instanceof IWorkingSet) {
                        navigator.setWorkingSet((IWorkingSet)newValue);
                    } else if (newValue == null) {
                        navigator.setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetActionGroup = new WorkingSetFilterActionGroup(viewSite.getShell(), workingSetUpdater);
        this.workingSetActionGroup.setWorkingSet(navigator.getWorkingSet());
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.contributedToViewMenu) {
            try {
                this.workingSetActionGroup.fillActionBars(actionBars);
            }
            finally {
                this.contributedToViewMenu = true;
            }
        }
    }

    public void dispose() {
        this.workingSetActionGroup.dispose();
        super.dispose();
    }
}

