/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.IField;
import org.eclipse.handly.examples.javamodel.IMember;
import org.eclipse.handly.examples.javamodel.IMethod;
import org.eclipse.handly.examples.javamodel.IType;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.dom.Modifier;

public class JavaFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    public static boolean isAbstract(IMember member) throws CoreException {
        if (JavaFlags.isInterfaceOrAnnotationMethod(member)) {
            return true;
        }
        return Flags.isAbstract((int)member.getFlags());
    }

    public static boolean isDeprecated(IMember member) throws CoreException {
        return Flags.isDeprecated((int)member.getFlags());
    }

    public static boolean isFinal(IMember member) throws CoreException {
        if (JavaFlags.isInterfaceOrAnnotationField(member)) {
            return true;
        }
        if (JavaFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isFinal((int)member.getFlags());
    }

    public static boolean isNative(IMember member) throws CoreException {
        return Flags.isNative((int)member.getFlags());
    }

    public static boolean isPackageVisible(IMember member) throws CoreException {
        return !JavaFlags.isPrivate(member) && !JavaFlags.isProtected(member) && !JavaFlags.isPublic(member);
    }

    public static boolean isPrivate(IMember member) throws CoreException {
        return Flags.isPrivate((int)member.getFlags());
    }

    public static boolean isProtected(IMember member) throws CoreException {
        return Flags.isProtected((int)member.getFlags());
    }

    public static boolean isPublic(IMember member) throws CoreException {
        if (JavaFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (JavaFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isPublic((int)member.getFlags());
    }

    public static boolean isStatic(IMember member) throws CoreException {
        if (JavaFlags.isNestedInterfaceOrAnnotation(member)) {
            return true;
        }
        if (member instanceof IMethod && JavaFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (JavaFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isStatic((int)member.getFlags());
    }

    public static boolean isStrictfp(IMember member) throws CoreException {
        return Flags.isStrictfp((int)member.getFlags());
    }

    public static boolean isSynchronized(IMember member) throws CoreException {
        return Flags.isSynchronized((int)member.getFlags());
    }

    public static boolean isSynthetic(IMember member) throws CoreException {
        return Flags.isSynthetic((int)member.getFlags());
    }

    public static boolean isAnnotation(IMember member) throws CoreException {
        return Flags.isAnnotation((int)member.getFlags());
    }

    public static boolean isEnum(IMember member) throws CoreException {
        return Flags.isEnum((int)member.getFlags());
    }

    public static boolean isVarargs(IMethod method) throws CoreException {
        return Flags.isVarargs((int)method.getFlags());
    }

    public static boolean isTransient(IMember member) throws CoreException {
        return Flags.isTransient((int)member.getFlags());
    }

    public static boolean isVolatile(IMember member) throws CoreException {
        return Flags.isVolatile((int)member.getFlags());
    }

    public static int getVisibilityCode(IMember member) throws CoreException {
        if (JavaFlags.isPublic(member)) {
            return 1;
        }
        if (JavaFlags.isProtected(member)) {
            return 4;
        }
        if (JavaFlags.isPackageVisible(member)) {
            return 0;
        }
        if (JavaFlags.isPrivate(member)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static String getVisibilityString(int visibilityCode) {
        if (Modifier.isPublic((int)visibilityCode)) {
            return VISIBILITY_STRING_PUBLIC;
        }
        if (Modifier.isProtected((int)visibilityCode)) {
            return VISIBILITY_STRING_PROTECTED;
        }
        if (Modifier.isPrivate((int)visibilityCode)) {
            return VISIBILITY_STRING_PRIVATE;
        }
        return VISIBILITY_STRING_PACKAGE;
    }

    public static int getVisibilityCode(String visibilityString) {
        Assert.isNotNull((Object)visibilityString);
        if (VISIBILITY_STRING_PACKAGE.equals(visibilityString)) {
            return 0;
        }
        if (VISIBILITY_STRING_PRIVATE.equals(visibilityString)) {
            return 2;
        }
        if (VISIBILITY_STRING_PROTECTED.equals(visibilityString)) {
            return 4;
        }
        if (VISIBILITY_STRING_PUBLIC.equals(visibilityString)) {
            return 1;
        }
        return -1;
    }

    public static void assertVisibility(int visibility) {
        Assert.isTrue((visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2 ? 1 : 0) != 0);
    }

    public static boolean isHigherVisibility(int newVisibility, int oldVisibility) {
        JavaFlags.assertVisibility(oldVisibility);
        JavaFlags.assertVisibility(newVisibility);
        switch (oldVisibility) {
            case 2: {
                return newVisibility == 0 || newVisibility == 1 || newVisibility == 4;
            }
            case 0: {
                return newVisibility == 1 || newVisibility == 4;
            }
            case 4: {
                return newVisibility == 1;
            }
            case 1: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    public static int getLowerVisibility(int visibility1, int visibility2) {
        if (JavaFlags.isHigherVisibility(visibility1, visibility2)) {
            return visibility2;
        }
        return visibility1;
    }

    public static int clearAccessModifiers(int flags) {
        return JavaFlags.clearFlag(7, flags);
    }

    private static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }

    private static boolean isInterfaceOrAnnotationMethod(IMember member) throws CoreException {
        return member instanceof IMethod && JavaFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationField(IMember member) throws CoreException {
        return member instanceof IType && JavaFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationMember(IMember member) throws CoreException {
        return member.getDeclaringType() != null && member.getDeclaringType().isInterface();
    }

    private static boolean isNestedInterfaceOrAnnotation(IMember member) throws CoreException {
        return member instanceof IType && member.getDeclaringType() != null && ((IType)member).isInterface();
    }

    private static boolean isEnumConstant(IMember member) throws CoreException {
        return member instanceof IField && JavaFlags.isEnum(member);
    }

    private JavaFlags() {
    }
}

