/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;

class AstUtil {
    static String getSignature(Type type) {
        StringBuilder builder = new StringBuilder();
        AstUtil.appendTypeName(type, builder);
        return Signature.createTypeSignature((String)builder.toString(), (boolean)false);
    }

    static String[] getSignatures(List<? extends Type> types) {
        String[] result = new String[types.size()];
        int i = 0;
        for (Type type : types) {
            result[i++] = AstUtil.getSignature(type);
        }
        return result;
    }

    private static void appendTypeName(Type type, StringBuilder builder) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            AstUtil.appendTypeName(arrayType.getElementType(), builder);
            int i = 0;
            while (i < arrayType.getDimensions()) {
                builder.append('[');
                builder.append(']');
                ++i;
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            AstUtil.appendTypeName(parameterizedType.getType(), builder);
            builder.append('<');
            Iterator iterator = parameterizedType.typeArguments().iterator();
            boolean isFirst = true;
            while (iterator.hasNext()) {
                if (!isFirst) {
                    builder.append(',');
                } else {
                    isFirst = false;
                }
                Type typeArgument = (Type)iterator.next();
                AstUtil.appendTypeName(typeArgument, builder);
            }
            builder.append('>');
        } else if (type instanceof PrimitiveType) {
            builder.append(((PrimitiveType)type).getPrimitiveTypeCode().toString());
        } else if (type instanceof QualifiedType) {
            QualifiedType qualifiedType = (QualifiedType)type;
            AstUtil.appendTypeName(qualifiedType.getQualifier(), builder);
            builder.append('.');
            builder.append(qualifiedType.getName().getIdentifier());
        } else if (type instanceof SimpleType) {
            builder.append(((SimpleType)type).getName().getFullyQualifiedName());
        } else if (type instanceof WildcardType) {
            builder.append('?');
            WildcardType wildcardType = (WildcardType)type;
            Type bound = wildcardType.getBound();
            if (bound == null) {
                return;
            }
            if (wildcardType.isUpperBound()) {
                builder.append(" extends ");
            } else {
                builder.append(" super ");
            }
            AstUtil.appendTypeName(bound, builder);
        }
    }

    private AstUtil() {
    }
}

