/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.examples.javamodel.JavaModelCore;
import org.eclipse.handly.internal.examples.javamodel.Activator;
import org.eclipse.handly.internal.examples.javamodel.DeltaProcessingState;
import org.eclipse.handly.internal.examples.javamodel.JavaElementDelta;
import org.eclipse.handly.internal.examples.javamodel.JavaModelBody;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.internal.examples.javamodel.JavaProjectBody;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentBody;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentRoot;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentRootBody;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.jdt.core.IClasspathEntry;

class DeltaProcessor
implements IResourceDeltaVisitor {
    private final DeltaProcessingState state;
    private final ElementDelta.Builder builder;

    DeltaProcessor(DeltaProcessingState state) {
        this.state = state;
        this.builder = new ElementDelta.Builder((ElementDelta)new JavaElementDelta(state.getJavaModel()));
    }

    IElementDelta getDelta() {
        return this.builder.getDelta();
    }

    boolean isEmptyDelta() {
        return this.builder.isEmptyDelta();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getResource().getType()) {
            case 8: {
                return this.processRoot(delta);
            }
            case 4: {
                return this.processProject(delta);
            }
            case 2: {
                return this.processFolder(delta);
            }
            case 1: {
                return this.processFile(delta);
            }
        }
        return true;
    }

    private boolean processRoot(IResourceDelta delta) throws CoreException {
        this.state.initOldClasspathInfo();
        this.state.initOldJavaProjectNames();
        if ((delta.getFlags() & 0x20000) != 0) {
            this.builder.markersChanged((IElement)this.state.getJavaModel(), delta.getMarkerDeltas());
        }
        return true;
    }

    private boolean processProject(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedProject(delta);
            }
            case 2: {
                return this.processRemovedProject(delta);
            }
            case 4: {
                return this.processChangedProject(delta);
            }
        }
        return true;
    }

    private boolean processAddedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            JavaProject javaProject = (JavaProject)JavaModelCore.create(project);
            this.addToModel(javaProject);
            this.translateAddedDelta(delta, javaProject);
            this.state.classpathChanged(javaProject, false);
        } else {
            this.addResourceDelta(this.state.getJavaModel(), delta);
        }
        return false;
    }

    private boolean processRemovedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (this.wasJavaProject(project)) {
            JavaProject javaProject = (JavaProject)JavaModelCore.create(project);
            this.removeFromModel(javaProject);
            this.translateRemovedDelta(delta, javaProject);
            this.state.classpathChanged(javaProject, true);
        } else {
            this.addResourceDelta(this.state.getJavaModel(), delta);
        }
        return false;
    }

    private boolean processChangedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        JavaProject javaProject = (JavaProject)JavaModelCore.create(project);
        if ((delta.getFlags() & 0x4000) != 0) {
            if (project.isOpen()) {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.addToModel(javaProject);
                    this.builder.changed((IElement)javaProject, 64L);
                    this.state.classpathChanged(javaProject, false);
                }
            } else if (this.wasJavaProject(project)) {
                this.removeFromModel(javaProject);
                this.builder.changed((IElement)javaProject, 64L);
                this.state.classpathChanged(javaProject, true);
            }
            this.addResourceDelta(this.state.getJavaModel(), delta);
            return false;
        }
        boolean isJavaProject = project.hasNature("org.eclipse.jdt.core.javanature");
        if ((delta.getFlags() & 0x80000) != 0) {
            boolean wasJavaProject = this.wasJavaProject(project);
            if (wasJavaProject != isJavaProject) {
                if (isJavaProject) {
                    this.addToModel(javaProject);
                    this.builder.added((IElement)javaProject);
                    this.state.classpathChanged(javaProject, false);
                } else {
                    this.removeFromModel(javaProject);
                    this.builder.removed((IElement)javaProject);
                    this.state.classpathChanged(javaProject, true);
                }
                this.addResourceDelta(this.state.getJavaModel(), delta);
                return false;
            }
            if (isJavaProject) {
                this.builder.changed((IElement)javaProject, 128L);
            }
        }
        if (isJavaProject) {
            Body parentBody;
            IElement[] children;
            if ((delta.getFlags() & 0x20000) != 0) {
                this.builder.markersChanged((IElement)javaProject, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.builder.changed((IElement)javaProject, 2048L);
            }
            if (!Arrays.asList(children = (parentBody = DeltaProcessor.findBody(javaProject.getParent())).getChildren()).contains(javaProject)) {
                this.addToModel(javaProject);
            }
            this.checkClasspathChange(delta);
            return true;
        }
        this.addResourceDelta(this.state.getJavaModel(), delta);
        return false;
    }

    private void checkClasspathChange(IResourceDelta projectDelta) {
        IResourceDelta delta = projectDelta.findMember((IPath)new Path(".classpath"));
        if (delta == null || delta.getResource().getType() != 1) {
            return;
        }
        JavaProject javaProject = (JavaProject)JavaModelCore.create(delta.getResource().getProject());
        switch (delta.getKind()) {
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) == 0) break;
            }
            case 1: 
            case 2: {
                if (!this.state.classpathChanged(javaProject, false)) break;
                this.builder.changed((IElement)javaProject, 0x100000000L);
                DeltaProcessor.close(javaProject);
            }
        }
    }

    private boolean processFolder(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedFolder(delta);
            }
            case 2: {
                return this.processRemovedFolder(delta);
            }
            case 4: {
                return this.processChangedFolder(delta);
            }
        }
        return false;
    }

    private boolean processAddedFolder(IResourceDelta delta) {
        IFolder folder = (IFolder)delta.getResource();
        IJavaElement element = this.state.createElement(folder, false);
        if (element != null) {
            this.addToModel(element);
            this.translateAddedDelta(delta, element);
            return true;
        }
        this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        return false;
    }

    private boolean processRemovedFolder(IResourceDelta delta) {
        IFolder folder = (IFolder)delta.getResource();
        IJavaElement element = this.state.createElement(folder, true);
        if (element != null) {
            this.removeFromModel(element);
            this.translateRemovedDelta(delta, element);
            return true;
        }
        this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        return false;
    }

    private boolean processChangedFolder(IResourceDelta delta) {
        IFolder folder = (IFolder)delta.getResource();
        IJavaElement element = this.state.createElement(folder, false);
        if (element != null) {
            if ((delta.getFlags() & 0x20000) != 0) {
                this.builder.markersChanged((IElement)element, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.builder.changed((IElement)element, 2048L);
            }
            return true;
        }
        this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        return false;
    }

    private boolean processFile(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedFile(delta);
            }
            case 2: {
                return this.processRemovedFile(delta);
            }
            case 4: {
                return this.processChangedFile(delta);
            }
        }
        return false;
    }

    private boolean processAddedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IJavaElement element = this.state.createElement(file, false);
        if (element != null) {
            this.addToModel(element);
            this.translateAddedDelta(delta, element);
        } else {
            this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        }
        return false;
    }

    private boolean processRemovedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IJavaElement element = this.state.createElement(file, true);
        if (element != null) {
            this.removeFromModel(element);
            this.translateRemovedDelta(delta, element);
        } else {
            this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        }
        return false;
    }

    private boolean processChangedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IJavaElement element = this.state.createElement(file, false);
        if (element != null) {
            if ((delta.getFlags() & 0xFFFCFFFF) != 0) {
                this.contentChanged(element);
            }
            if ((delta.getFlags() & 0x20000) != 0) {
                this.builder.markersChanged((IElement)element, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.builder.changed((IElement)element, 2048L);
            }
        } else {
            this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        }
        return false;
    }

    private boolean wasJavaProject(IProject project) {
        return this.state.getOldJavaProjectNames().contains(project.getName());
    }

    private void addToModel(IJavaElement element) {
        Body parentBody = DeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            if (element instanceof PackageFragmentRoot) {
                this.addPackageFragmentRoot(parentBody, (PackageFragmentRoot)element);
            } else {
                parentBody.addChild((IElement)element);
            }
        }
        DeltaProcessor.close(element);
    }

    private void addPackageFragmentRoot(Body parentBody, PackageFragmentRoot root) {
        IClasspathEntry[] classpath;
        IElement[] roots = parentBody.getChildren();
        if (roots.length == 0) {
            parentBody.addChild((IElement)root);
            return;
        }
        try {
            classpath = root.getParent().getRawClasspath();
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
            parentBody.addChild((IElement)root);
            return;
        }
        IPath rootPath = root.getPath();
        int indexToInsert = -1;
        int lastComparedIndex = -1;
        int i = 0;
        int j = 0;
        while (i < roots.length && j < classpath.length) {
            IPath entryPath = classpath[j].getPath();
            if (lastComparedIndex != j && rootPath.equals((Object)entryPath)) {
                indexToInsert = i;
                break;
            }
            lastComparedIndex = j++;
            if (!((IPackageFragmentRoot)roots[i]).getPath().equals((Object)entryPath)) continue;
            ++i;
        }
        while (i < roots.length) {
            if (roots[i].equals((Object)root)) {
                return;
            }
            if (!((IPackageFragmentRoot)roots[i]).getPath().equals((Object)rootPath)) break;
            ++i;
        }
        if (indexToInsert < 0) {
            parentBody.addChild((IElement)root);
        } else {
            int newSize = roots.length + 1;
            IElement[] newChildren = new IElement[newSize];
            if (indexToInsert > 0) {
                System.arraycopy(roots, 0, newChildren, 0, indexToInsert);
            }
            newChildren[indexToInsert] = root;
            System.arraycopy(roots, indexToInsert, newChildren, indexToInsert + 1, newSize - indexToInsert - 1);
            parentBody.setChildren(newChildren);
        }
    }

    private void removeFromModel(IJavaElement element) {
        Body parentBody = DeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            parentBody.removeChild((IElement)element);
        }
        DeltaProcessor.close(element);
        if (element instanceof IJavaProject) {
            JavaModelManager.INSTANCE.removePerProjectInfo(((IJavaProject)element).getProject());
        }
    }

    private void translateAddedDelta(IResourceDelta delta, IJavaElement element) {
        if ((delta.getFlags() & 0x1000) == 0) {
            this.builder.added((IElement)element);
        } else {
            IJavaElement movedFromElement = this.state.createElement(DeltaProcessor.getResource(delta.getMovedFromPath(), delta.getResource().getType()), true);
            if (movedFromElement == null) {
                this.builder.added((IElement)element);
            } else {
                this.builder.movedTo((IElement)element, (IElement)movedFromElement);
            }
        }
    }

    private void translateRemovedDelta(IResourceDelta delta, IJavaElement element) {
        if ((delta.getFlags() & 0x2000) == 0) {
            this.builder.removed((IElement)element);
        } else {
            IJavaElement movedToElement = this.state.createElement(DeltaProcessor.getResource(delta.getMovedToPath(), delta.getResource().getType()), false);
            if (movedToElement == null) {
                this.builder.removed((IElement)element);
            } else {
                this.builder.movedFrom((IElement)element, (IElement)movedToElement);
            }
        }
    }

    private void contentChanged(IJavaElement element) {
        if (element instanceof ICompilationUnit && ((ICompilationUnit)element).isWorkingCopy()) {
            this.builder.changed((IElement)element, 513L);
            return;
        }
        DeltaProcessor.close(element);
        this.builder.changed((IElement)element, 1L);
    }

    private void addResourceDelta(IJavaElement element, IResourceDelta resourceDelta) {
        if (element == null) {
            return;
        }
        Body body = DeltaProcessor.findBody(element);
        if (body != null) {
            if (body instanceof JavaModelBody) {
                ((JavaModelBody)body).setNonJavaProjects(null);
            } else if (body instanceof JavaProjectBody) {
                ((JavaProjectBody)body).setNonJavaResources(null);
            } else if (body instanceof PackageFragmentRootBody) {
                ((PackageFragmentRootBody)body).setNonJavaResources(null);
            } else if (body instanceof PackageFragmentBody) {
                ((PackageFragmentBody)body).setNonJavaResources(null);
            } else {
                throw new AssertionError();
            }
        }
        this.builder.addResourceDelta((IElement)element, resourceDelta);
    }

    private static Body findBody(IJavaElement element) {
        return (Body)((IElementImplExtension)element).hFindBody();
    }

    private static void close(IJavaElement element) {
        ((IElementImplExtension)element).hClose();
    }

    private static IResource getResource(IPath fullPath, int resourceType) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        switch (resourceType) {
            case 8: {
                return root;
            }
            case 4: {
                return root.getProject(fullPath.lastSegment());
            }
            case 2: {
                return root.getFolder(fullPath);
            }
            case 1: {
                return root.getFile(fullPath);
            }
        }
        return null;
    }
}

