/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.internal.examples.javamodel.IJavaElementInternal;
import org.eclipse.handly.internal.examples.javamodel.JavaModelBody;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Element;

public class JavaModel
extends Element
implements IJavaModel,
IJavaElementInternal,
IModel {
    private final IWorkspace workspace;

    public JavaModel(IWorkspace workspace) {
        super(null, null);
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
    }

    public int getApiLevel() {
        return 0;
    }

    public IContext getModelContext() {
        return JavaModelManager.INSTANCE.getModelContext();
    }

    @Override
    public void addElementChangeListener(IElementChangeListener listener) {
        JavaModelManager.INSTANCE.getNotificationManager().addElementChangeListener(listener);
    }

    @Override
    public void removeElementChangeListener(IElementChangeListener listener) {
        JavaModelManager.INSTANCE.getNotificationManager().removeElementChangeListener(listener);
    }

    @Override
    public IJavaProject getJavaProject(String name) {
        return new JavaProject(this, this.workspace.getRoot().getProject(name));
    }

    @Override
    public IJavaProject[] getJavaProjects() throws CoreException {
        IJavaElement[] children = this.getChildren();
        int length = children.length;
        IJavaProject[] result = new IJavaProject[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public IProject[] getNonJavaProjects() throws CoreException {
        return ((JavaModelBody)((Object)this.hBody())).getNonJavaProjects(this);
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaModel other = (JavaModel)obj;
        return this.workspace.equals(other.workspace);
    }

    public int hashCode() {
        return this.workspace.hashCode();
    }

    public IResource hResource() {
        return this.workspace.getRoot();
    }

    public boolean hExists() {
        return true;
    }

    public void hValidateExistence(IContext context) throws CoreException {
    }

    public void hBuildStructure(IContext context, IProgressMonitor monitor) throws CoreException {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<JavaProject> javaProjects = new ArrayList<JavaProject>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProjects.add(new JavaProject(this, project));
            }
            ++n2;
        }
        JavaModelBody body = new JavaModelBody();
        body.setChildren(javaProjects.toArray(Body.NO_CHILDREN));
        ((Map)context.get(NEW_ELEMENTS)).put(this, body);
    }

    public void hToStringName(StringBuilder builder, IContext context) {
        builder.append("Java Model");
    }
}

