/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.util.AdapterUtil;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    public static final EditorUtility DEFAULT = new EditorUtility();

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IEditorInput) {
            return (IEditorInput)element;
        }
        IElement adapterElement = (IElement)AdapterUtil.getAdapter((Object)element, IElement.class, (boolean)true);
        IResource resource = adapterElement != null ? Elements.getResource((IElement)adapterElement) : ResourceUtil.getResource((Object)element);
        if (resource instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        return null;
    }

    public IEditorReference findEditor(IWorkbenchPage page, Object element) {
        IEditorReference found;
        IElement adapterElement;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        if (element == null) {
            throw new IllegalArgumentException();
        }
        IEditorInput input = this.getEditorInput(element);
        if (input == null) {
            return null;
        }
        IEditorReference[] references = page.findEditors(input, null, 1);
        if (references.length == 0) {
            return null;
        }
        IEditorReference result = references[0];
        IEditorPart editor = result.getEditor(false);
        if (editor instanceof ITextEditor && (adapterElement = (IElement)AdapterUtil.getAdapter((Object)element, IElement.class, (boolean)true)) instanceof ISourceElement && (found = this.findSourceEditor(references, (ISourceElement)adapterElement)) != null) {
            result = found;
        }
        return result;
    }

    public void revealElement(IEditorPart editor, Object element) {
        ITextEditor textEditor;
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        if (element == null) {
            throw new IllegalArgumentException();
        }
        IElement adapterElement = (IElement)AdapterUtil.getAdapter((Object)element, IElement.class, (boolean)true);
        if (adapterElement instanceof ISourceElement && (textEditor = (ITextEditor)AdapterUtil.getAdapter((Object)editor, ITextEditor.class, (boolean)false)) != null && this.revealSourceElement(textEditor, (ISourceElement)adapterElement)) {
            return;
        }
        editor.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(element));
    }

    protected IBuffer getBuffer(ISourceElement element) {
        block3: {
            ISourceFile sourceFile = Elements.getSourceFile((ISourceElement)element);
            if (sourceFile != null) {
                try {
                    return Elements.getBuffer((ISourceFile)sourceFile);
                }
                catch (CoreException e) {
                    if (!Elements.exists((IElement)element)) break block3;
                    Activator.log(e.getStatus());
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private IEditorReference findSourceEditor(IEditorReference[] references, ISourceElement element) {
        var3_3 = null;
        var4_5 = null;
        try {
            buffer = this.getBuffer(element);
            try {
                if (buffer != null) {
                    var9_8 = references;
                    var8_9 = references.length;
                    var7_10 = 0;
                    while (true) {
                        reference = var9_8[var7_10];
                        editor = reference.getEditor(true);
                        if (editor != null && (textEditor = (ITextEditor)AdapterUtil.getAdapter((Object)editor, ITextEditor.class, (boolean)false)) != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null && document.equals(buffer.getDocument())) {
                            return reference;
                        }
                        ++var7_10;
                        return var7_10;
                    }
                }
            }
            finally {
                if (var7_10 < var8_9) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    private boolean revealSourceElement(ITextEditor editor, ISourceElement element) {
        block10: {
            Throwable throwable = null;
            Object var4_5 = null;
            try (IBuffer buffer = this.getBuffer(element);){
                IDocument document;
                if (buffer == null || (document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput())) == null || !document.equals(buffer.getDocument())) break block10;
                Elements.ensureReconciled((ISourceElement)element, null);
                TextRange identifyingRange = Elements.getSourceElementInfo2((ISourceElement)element).getIdentifyingRange();
                if (identifyingRange == null) break block10;
                editor.selectAndReveal(identifyingRange.getOffset(), identifyingRange.getLength());
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return false;
    }
}

