/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.ISourceFileImplSupport;
import org.eclipse.handly.ui.IWorkingCopyManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class SourceFileDocumentProvider
extends TextFileDocumentProvider
implements IWorkingCopyManager {
    private static final ISourceFile[] NO_WORKING_COPIES = new ISourceFile[0];

    public SourceFileDocumentProvider() {
        this(null);
    }

    public SourceFileDocumentProvider(IDocumentProvider parent) {
        super(parent);
    }

    @Override
    public ISourceFile getWorkingCopy(Object element) {
        SourceFileInfo info = (SourceFileInfo)this.getFileInfo(element);
        if (info == null) {
            return null;
        }
        return info.workingCopy;
    }

    @Override
    public ISourceFile getWorkingCopy(IDocument document) {
        Iterator it = this.getFileInfosIterator();
        while (it.hasNext()) {
            SourceFileInfo info = (SourceFileInfo)((Object)it.next());
            if (!info.fTextFileBuffer.getDocument().equals(document)) continue;
            return info.workingCopy;
        }
        return null;
    }

    @Override
    public ISourceFile[] getWorkingCopies() {
        ArrayList<ISourceFile> result = new ArrayList<ISourceFile>();
        Iterator it = this.getFileInfosIterator();
        while (it.hasNext()) {
            SourceFileInfo info = (SourceFileInfo)((Object)it.next());
            if (info.workingCopy == null) continue;
            result.add(info.workingCopy);
        }
        return result.toArray(NO_WORKING_COPIES);
    }

    protected abstract ISourceFile getSourceFile(Object var1);

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceFileInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        SourceFileInfo info = (SourceFileInfo)super.createFileInfo(element);
        if (info == null) {
            return null;
        }
        boolean f = false;
        try {
            ISourceFile workingCopy = this.acquireWorkingCopy(element, info);
            if (workingCopy != null) {
                if (!Elements.isWorkingCopy((ISourceFile)workingCopy)) {
                    throw new AssertionError();
                }
                Throwable throwable = null;
                Object var6_7 = null;
                try (IBuffer buffer = Elements.getBuffer((ISourceFile)workingCopy);){
                    if (buffer.getDocument() != info.fTextFileBuffer.getDocument()) {
                        this.releaseWorkingCopy(workingCopy, element, info);
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                info.workingCopy = workingCopy;
            }
            f = true;
            SourceFileInfo sourceFileInfo = info;
            return sourceFileInfo;
        }
        finally {
            if (!f) {
                super.disposeFileInfo(element, (TextFileDocumentProvider.FileInfo)info);
            }
        }
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        try {
            ISourceFile workingCopy = ((SourceFileInfo)info).workingCopy;
            if (workingCopy != null) {
                this.releaseWorkingCopy(workingCopy, element, info);
            }
        }
        finally {
            super.disposeFileInfo(element, info);
        }
    }

    protected ISourceFile acquireWorkingCopy(Object element, TextFileDocumentProvider.FileInfo info) throws CoreException {
        ISourceFile sourceFile = this.getSourceFile(element);
        if (sourceFile instanceof ISourceFileImplSupport) {
            ((ISourceFileImplSupport)sourceFile).hBecomeWorkingCopy(Contexts.EMPTY_CONTEXT, null);
            return sourceFile;
        }
        return null;
    }

    protected void releaseWorkingCopy(ISourceFile workingCopy, Object element, TextFileDocumentProvider.FileInfo info) {
        ((ISourceFileImplSupport)workingCopy).hReleaseWorkingCopy();
    }

    protected static class SourceFileInfo
    extends TextFileDocumentProvider.FileInfo {
        ISourceFile workingCopy;

        protected SourceFileInfo() {
        }
    }
}

