/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import java.util.Comparator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class LabelComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        String name2;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        String name1 = this.getLabel(viewer, e1);
        if (name1 == null) {
            name1 = "";
        }
        if ((name2 = this.getLabel(viewer, e2)) == null) {
            name2 = "";
        }
        Comparator comparator = this.getComparator();
        return comparator.compare(name1, name2);
    }

    protected String getLabel(Viewer viewer, Object element) {
        if (!(viewer instanceof ContentViewer)) {
            return null;
        }
        IBaseLabelProvider labelProvider = ((ContentViewer)viewer).getLabelProvider();
        if (labelProvider instanceof ILabelProvider) {
            return ((ILabelProvider)labelProvider).getText(element);
        }
        if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            return ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider).getStyledText(element).toString();
        }
        if (labelProvider instanceof DelegatingStyledCellLabelProvider) {
            return ((DelegatingStyledCellLabelProvider)labelProvider).getStyledStringProvider().getStyledText(element).toString();
        }
        return null;
    }
}

