/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.handly.ui.viewer.ProblemLabelDecorator;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.ui.ide.ResourceUtil;

public class ProblemMarkerLabelDecorator
extends ProblemLabelDecorator {
    @Override
    protected ProblemLabelDecorator.Severity computeProblemSeverity(Object element, IDecorationContext context) {
        try {
            return this.computeProblemSeverityFromMarkers(element, context);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 376) {
                Activator.log(e.getStatus());
            }
            return null;
        }
    }

    protected ProblemLabelDecorator.Severity computeProblemSeverityFromMarkers(Object element, IDecorationContext context) throws CoreException {
        IResource resource = null;
        IElement elementAdapter = this.getContentAdapter(context).adapt(element);
        resource = element instanceof IResource ? (IResource)element : (elementAdapter != null ? Elements.getResource((IElement)elementAdapter) : ResourceUtil.getResource((Object)element));
        if (resource == null || !resource.isAccessible()) {
            return null;
        }
        TextRange textRange = null;
        if (elementAdapter instanceof ISourceConstruct) {
            ISourceConstruct sourceConstruct = (ISourceConstruct)elementAdapter;
            if (!Elements.exists((IElement)sourceConstruct)) {
                return null;
            }
            textRange = Elements.getSourceElementInfo((ISourceElement)sourceConstruct).getFullRange();
            if (textRange == null) {
                return null;
            }
        }
        return ProblemMarkerLabelDecorator.findMaxProblemSeverity(resource, 2, textRange);
    }

    protected IContentAdapter getContentAdapter(IDecorationContext context) {
        IContentAdapterProvider provider = (IContentAdapterProvider)context.getProperty(IContentAdapterProvider.class.getName());
        if (provider != null) {
            return provider.getContentAdapter();
        }
        return NullContentAdapter.INSTANCE;
    }

    protected static ProblemLabelDecorator.Severity findMaxProblemSeverity(IResource resource, int depth, TextRange textRange) throws CoreException {
        int severity = 0;
        if (textRange == null) {
            severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, depth);
        } else {
            IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
            if (markers != null) {
                int i = 0;
                while (i < markers.length && severity != 2) {
                    int val;
                    IMarker marker = markers[i];
                    if (ProblemMarkerLabelDecorator.isMarkerInRange(marker, textRange) && ((val = marker.getAttribute("severity", -1)) == 1 || val == 2)) {
                        severity = val;
                    }
                    ++i;
                }
            }
        }
        if (severity == 2) {
            return ProblemLabelDecorator.Severity.ERROR;
        }
        if (severity == 1) {
            return ProblemLabelDecorator.Severity.WARNING;
        }
        return null;
    }

    private static boolean isMarkerInRange(IMarker marker, TextRange textRange) {
        int position = marker.getAttribute("charStart", -1);
        return textRange.strictlyCovers(position);
    }
}

