/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal;

import java.util.concurrent.ExecutionException;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class DisplaySynchronizer
extends UiSynchronizer {
    private final Display display;

    public DisplaySynchronizer(Display display) {
        this.display = display;
        if (this.display == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Thread getThread() {
        try {
            return this.display.getThread();
        }
        catch (SWTException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void asyncExec(Runnable runnable) {
        try {
            this.display.asyncExec(runnable);
        }
        catch (SWTException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void syncExec(Runnable runnable) throws ExecutionException {
        try {
            this.display.syncExec(runnable);
        }
        catch (SWTException e) {
            if (e.code == 46) {
                throw new ExecutionException(e.throwable);
            }
            throw new IllegalStateException(e);
        }
    }
}

