/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;

public class DefaultWorkingCopyInfo
extends WorkingCopyInfo {
    private final Object reconcilingLock = new Object();
    private volatile ISnapshot reconciledSnapshot;

    public DefaultWorkingCopyInfo(ISourceFileImplSupport sourceFile, IBuffer buffer) {
        super(sourceFile, buffer);
    }

    @Override
    protected final boolean needsReconciling() {
        return !this.getBuffer().getSnapshot().isEqualTo(this.reconciledSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
        if (context.containsKey(SOURCE_AST)) {
            throw new IllegalArgumentException();
        }
        Object object = this.reconcilingLock;
        synchronized (object) {
            boolean needsReconciling = this.needsReconciling();
            if (needsReconciling || context.getOrDefault(Elements.FORCE_RECONCILING).booleanValue()) {
                NonExpiringSnapshot snapshot = new NonExpiringSnapshot(this.getBuffer());
                this.reconcile0(Contexts.with(Contexts.of(SOURCE_CONTENTS, snapshot.getContents()), Contexts.of(SOURCE_SNAPSHOT, snapshot.getWrappedSnapshot()), Contexts.of(RECONCILING_FORCED, Boolean.valueOf(!needsReconciling)), context), monitor);
                this.reconciledSnapshot = snapshot.getWrappedSnapshot();
            }
        }
    }
}

