/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.model.impl.IElementImplExtension;

public class ElementDifferencer {
    private final ElementDelta.Builder builder;
    private final int maxDepth;
    private Map<IElement, Object> oldBodies;
    private Map<IElement, ListItem> oldPositions;
    private Map<IElement, ListItem> newPositions;
    private Set<IElement> added;
    private Set<IElement> removed;
    private boolean built;

    public ElementDifferencer(ElementDelta.Builder builder) {
        this(builder, Integer.MAX_VALUE);
    }

    public ElementDifferencer(ElementDelta.Builder builder, int maxDepth) {
        if (builder == null) {
            throw new IllegalArgumentException();
        }
        this.builder = builder;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordBody(this.getElement(), 0);
    }

    public IElement getElement() {
        return this.getDelta().hElement();
    }

    public void buildDelta() {
        if (this.built) {
            throw new IllegalStateException("Delta has already been built");
        }
        this.built = true;
        IElement element = this.getElement();
        this.recordNewPositions(element, 0);
        this.findAdditions(element, 0);
        this.findDeletions();
        this.findChangesInPositioning(element, 0);
        ElementDifferencer.trimDelta(this.getDelta());
    }

    public ElementDelta.Builder getDeltaBuilder() {
        return this.builder;
    }

    public ElementDelta getDelta() {
        return this.getDeltaBuilder().getDelta();
    }

    public boolean isEmptyDelta() {
        return this.getDeltaBuilder().isEmptyDelta();
    }

    public String toString() {
        return this.getDelta().toString();
    }

    protected void recordBody(Object body, IElement element) {
        this.oldBodies.put(element, body);
    }

    protected void findContentChange(Object oldBody, Object newBody, IElement element) {
        ((Body)newBody).findContentChange((Body)oldBody, element, this.getDeltaBuilder());
    }

    private void initialize() {
        this.oldBodies = new HashMap<IElement, Object>(20);
        this.oldPositions = new HashMap<IElement, ListItem>(20);
        this.newPositions = new HashMap<IElement, ListItem>(20);
        this.oldPositions.put(this.getElement(), new ListItem(null, null));
        this.newPositions.put(this.getElement(), new ListItem(null, null));
        this.added = new HashSet<IElement>(5);
        this.removed = new HashSet<IElement>(5);
    }

    private void recordBody(IElement element, int depth) {
        Object body;
        if (depth >= this.maxDepth) {
            return;
        }
        try {
            body = ((IElementImplExtension)element).hBody();
        }
        catch (CoreException e) {
            return;
        }
        this.recordBody(body, element);
        IElement[] children = ((IElementImplExtension)element).hChildren(body);
        this.insertPositions(children, false);
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            this.recordBody(child, depth + 1);
            ++n2;
        }
    }

    private void recordNewPositions(IElement newElement, int depth) {
        IElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        try {
            children = Elements.getChildren(newElement);
        }
        catch (CoreException e) {
            return;
        }
        this.insertPositions(children, true);
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            this.recordNewPositions(child, depth + 1);
            ++n2;
        }
    }

    private void insertPositions(IElement[] elements, boolean isNew) {
        int length = elements.length;
        IElement previous = null;
        IElement current = null;
        IElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IElement iElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.newPositions.put(current, new ListItem(previous, next));
            } else {
                this.oldPositions.put(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private void findAdditions(IElement newElement, int depth) {
        Object oldBody = this.getOldBody(newElement);
        if (oldBody == null && depth < this.maxDepth) {
            this.getDeltaBuilder().added(newElement);
            this.added(newElement);
        } else {
            this.removeOldBody(newElement);
        }
        if (depth >= this.maxDepth) {
            this.getDeltaBuilder().changed(newElement, 1L);
            return;
        }
        if (oldBody != null) {
            Object newBody;
            try {
                newBody = ((IElementImplExtension)newElement).hBody();
            }
            catch (CoreException e) {
                return;
            }
            this.findContentChange(oldBody, newBody, newElement);
            IElement[] iElementArray = ((IElementImplExtension)newElement).hChildren(newBody);
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement child = iElementArray[n2];
                this.findAdditions(child, depth + 1);
                ++n2;
            }
        }
    }

    private void findDeletions() {
        for (IElement element : this.oldBodies.keySet()) {
            this.getDeltaBuilder().removed(element);
            this.removed(element);
        }
    }

    private void findChangesInPositioning(IElement element, int depth) {
        IElement[] children;
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.getDeltaBuilder().changed(element, 16L);
        }
        try {
            children = Elements.getChildren(element);
        }
        catch (CoreException e) {
            return;
        }
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            this.findChangesInPositioning(child, depth + 1);
            ++n2;
        }
    }

    private static void trimDelta(ElementDelta delta) {
        if (delta.hKind() == 2) {
            delta.hClearAffectedChildren();
        } else {
            ElementDelta[] elementDeltaArray = delta.hAffectedChildren();
            int n = elementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDelta child = elementDeltaArray[n2];
                ElementDifferencer.trimDelta(child);
                ++n2;
            }
        }
    }

    private void added(IElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removed(IElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private boolean isPositionedCorrectly(IElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IElement oldPrevious = oldListItem.previous;
        IElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private Object getOldBody(IElement element) {
        return this.oldBodies.get(element);
    }

    private void removeOldBody(IElement element) {
        this.oldBodies.remove(element);
    }

    private ListItem getOldPosition(IElement element) {
        return this.oldPositions.get(element);
    }

    private ListItem getNewPosition(IElement element) {
        return this.newPositions.get(element);
    }

    private static class ListItem {
        public IElement previous;
        public IElement next;

        public ListItem(IElement previous, IElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

